﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Collections;

namespace nft.framework {
    public interface IVersionCompatible {
        /// <summary>
        /// Called when some field are not deserialized properly, (maybe because of version difference).
        /// Object which implements this should try to apply unmatched fields.
        /// </summary>
        /// <param name="fields">The map of field name to the value, value can be null if there is no data for the field in the archive.</param>
        /// <returns>returns true when all fields are successfuly processed.</returns>
        bool ProcesseUnmatchedFields(Hashtable fields);
    }
}
