using System;
using System.Xml;
using nft.framework;
using nft.framework.plugin;
using nft.util;
using nft.ui.mainframe;
using nft.framework.drawing;

namespace nft.contributions.ui
{
	/// <summary>
	/// CtbMenuItem ̊Tv̐łB
	/// </summary>
	public class CtbCommandUIGroup : Contribution
	{
		
		public readonly string location;
		protected readonly string after = null;
		protected readonly string before = null;

		/// <summary>
		/// Contributes a menu and submenu items to mainmenu.
		/// 
		/// This contribution can add several items at once.
		/// </summary>
        public CtbCommandUIGroup(Plugin p, XmlElement e)
            : base(p, e) 
		{
            string cap = XmlUtil.GetSingleNodeText(e, "caption", null);
            string scap = XmlUtil.GetSingleNodeText(e, "short-caption", cap);
            string lcap = XmlUtil.GetSingleNodeText(e, "long-caption", cap);
            string desc = XmlUtil.GetSingleNodeText(e, "description", lcap);
            string iconpath = XmlUtil.GetSingleNodeText(e, "icon", cap);
            ImageRef imgref = PluginImageManager.GetBundledImageRef(this, iconpath);
		}

	}
}
