#!/usr/bin/ruby
# $Id: PAR.rb,v 1.1 2008/10/05 01:33:42 nishimoto Exp $
#
# Parallel command handling module for Galatea
# by Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
#
# set Init = 1 [Queue ID : only 1 is supported now]
# set Cmd = sleep 3
# set Cmd = to @FSM set FaceExp = HAPPY 1 100 1000
#
# rep Speak.stat = hogehoge
# or 
# set Run = NOW
#
# TODO:
#   multi-thread (non-blocking command handling)
#   multiple-queue (needed?)
#   better synchronization mechanism
#

require 'GalateaBase.rb'

class PAR < GalateaBase

  def initialize
    super
    @modulename = "PAR"
    @debug = false
    @id = 0
    @queue1 = Array.new
  end


  def exec_queue()
    while @queue1.length > 0 do
      print_debug("queue1.length=" + @queue1.length.to_s)
      cmd = @queue1.delete_at(0)
      print_debug("cmd=" + cmd)
      cmd =~ /(.*)\s+(.*)$/
      if $1 == "sleep" then
	print_debug("sleeping " +$2)
	sleep $2.to_f 
     else
	print_out(cmd)
	print_debug(cmd)
      end
    end
    print_debug("queue1 done.")
  end
  

  def do_set(slot, arg)
    super
    if slot == "Init"
      @id = arg.to_i
      @queue1 = []
    elsif slot == "Cmd"
      # set Cmd = sleep 5
      # set Cmd = to @FSM set FaceExp = HAPPY 1 100 0
      @queue1.push(arg)
    elsif slot == "Run" && arg == "NOW"
      # set Run = NOW
      exec_queue()
    end
  end


  def accept_from(mod, str)
    if mod == "SSM" && /rep\s+Speak\.stat\s*=\s*(.*)$/ =~ str
      exec_queue()
    elsif mod == "FSM" && /rep\s+Speak\.stat\s*=\s*(.*)$/ =~ str
      exec_queue()
    elsif mod == "SND" && /tell start/ =~ str
      exec_queue()
    end
  end
  
end

# ------------------------------

PAR.new.run

# end of file
