#!/usr/bin/ruby -Ke
# $Id: SSM-espeak.rb,v 1.1 2008/10/05 01:33:42 nishimoto Exp $
#
# by Takuya NISHIMOTO (nishimoto@m.ieice.org)
#

require 'GalateaBase.rb'

class SSM < GalateaBase

  def initialize
    super
    @modulename = 'SSM'
    @debug = true
    @text = ''
    @pho = 'a[100] u[100] a[100] u[100] a[100] u[100] a[100] u[100] a[100] u[100]'
    @len = 1000

    @cmd = nil
    @arg = nil
    @stat = nil
    Thread.start do
      while true
    	if @cmd != nil
          print_rep "Speak.stat = SPEAKING"
          print_rep "Speak.len = #{@len.to_s}"
          print_rep "Speak.utt = #{@pho}"
    	  system @cmd
          print_rep "Speak.stat = IDLE"
    	  @cmd = nil
    	end
    	if @stat != nil
          print_rep "Speak.stat = #{@stat}"
          @stat = nil
    	end
    	sleep 0.001
      end
    end
   	sleep 1
    print_rep "Run = LIVE"
  end
  
  def do_set(slot, arg)
    super
	case slot
	when 'Text'
	  @text = arg
      print_rep "Speak.stat = PROCESSING"
	  print_rep "Text.text = #{@text}"
	  print_rep "Speak.text = #{@text}"
	  print_rep "Text.pho = #{@pho}"
	  print_rep "Speak.pho = #{@pho}"
	  print_rep "Text.dur = #{@len.to_s}"
	  print_rep "Speak.dur = #{@len.to_s}"
      sleep 0.0001
      @stat = 'READY'
	when 'Speak'
	  if (arg == 'NOW' or arg == '+ 0') and @text != nil
	    @cmd = "/usr/bin/espeak '#{@text}'"
	    @text = nil
	  end
	end
  end

end

SSM.new.run

# end of file
