/*
 * Decompiled with CFR 0.152.
 */
package ow.ipmulticast;

import java.io.IOException;
import java.net.Inet4Address;
import java.util.logging.Level;
import java.util.logging.Logger;
import ow.ipmulticast.IPMulticastHandler;
import ow.ipmulticast.Native;
import ow.ipmulticast.Utilities;
import ow.ipmulticast.VirtualInterface;

public final class IPMulticast {
    private static final Logger logger = Logger.getLogger("ipmulticast");
    private static IPMulticast instance = null;
    private boolean working = false;
    private boolean suspended = false;
    private Thread receiverThread = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IPMulticast getInstance() throws IOException {
        Class<IPMulticast> clazz = IPMulticast.class;
        synchronized (IPMulticast.class) {
            if (instance == null) {
                instance = new IPMulticast();
                Native.initialize();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private IPMulticast() {
    }

    public synchronized void start(final IPMulticastHandler handler) {
        if (this.working) {
            return;
        }
        Runnable r = new Runnable(){
            MulticastMessage container = new MulticastMessage();
            Inet4Address srcAddr;
            Inet4Address destAddr;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    while (true) {
                        IPMulticast iPMulticast = IPMulticast.this;
                        synchronized (iPMulticast) {
                            while (IPMulticast.this.suspended) {
                                IPMulticast.this.wait();
                            }
                        }
                        if (Thread.interrupted()) break;
                        try {
                            Native.receiveMulticast(this.container);
                        }
                        catch (IOException e) {
                            logger.log(Level.WARNING, "Native#receiveMulticast() throws an IOException.", e);
                            break;
                        }
                        this.srcAddr = Utilities.intToInet4Address(this.container.srcaddr);
                        this.destAddr = Utilities.intToInet4Address(this.container.destaddr);
                        handler.process(this.srcAddr, this.container.srcport, this.destAddr, this.container.destport, this.container.id, this.container.ttl, this.container.data);
                    }
                }
                catch (InterruptedException e) {
                    logger.log(Level.WARNING, "Multicast receiving daemon interrupted and die.");
                }
                Native.stop();
                IPMulticast.this.working = false;
            }
        };
        this.receiverThread = new Thread(r);
        this.receiverThread.setName("Multicast receiving daemon");
        this.receiverThread.setDaemon(true);
        this.receiverThread.start();
        this.working = true;
    }

    public synchronized void stop() {
        if (this.receiverThread != null) {
            this.receiverThread.interrupt();
            this.receiverThread = null;
        }
        Native.stop();
        this.working = false;
    }

    public synchronized void suspend() {
        this.suspended = true;
    }

    public synchronized void resume() {
        this.suspended = false;
        this.notifyAll();
    }

    public synchronized void send(Inet4Address srcAddress, int srcPort, Inet4Address destAddress, int destPort, int id, int ttl, int payloadLength, byte[] payload) {
        Native.sendMulticast(Utilities.Inet4AddressToInt(srcAddress), srcPort, Utilities.Inet4AddressToInt(destAddress), destPort, id, ttl, payloadLength, payload);
    }

    public void joinGroup(Inet4Address group, VirtualInterface vif) {
        Native.joinGroup(Utilities.Inet4AddressToInt(group), Utilities.Inet4AddressToInt(vif.getLocalAddress()), vif.getIfIndex());
    }

    public void leaveGroup(Inet4Address group, VirtualInterface vif) {
        Native.leaveGroup(Utilities.Inet4AddressToInt(group), Utilities.Inet4AddressToInt(vif.getLocalAddress()), vif.getIfIndex());
    }

    static class MulticastMessage {
        int srcaddr;
        int srcport;
        int destaddr;
        int destport;
        int id;
        int ttl;
        byte[] data;
        int datalen;

        MulticastMessage() {
        }
    }
}

