/*
 * Decompiled with CFR 0.152.
 */
package ow.routing;

import java.io.Serializable;
import ow.id.IDAddressPair;

public final class RoutingHop
implements Serializable {
    private final IDAddressPair node;
    private final long time;

    private RoutingHop(IDAddressPair node, long time) {
        this.node = node;
        this.time = time;
    }

    public static RoutingHop newInstance(IDAddressPair node) {
        return new RoutingHop(node, System.currentTimeMillis());
    }

    public IDAddressPair getIDAddressPair() {
        return this.node;
    }

    public long getTime() {
        return this.time;
    }

    RoutingHop stripRoutingContext() {
        return new RoutingHop(this.node.getIDAddressPair(), this.time);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.node);
        sb.append(" (").append(this.time).append(")");
        return sb.toString();
    }
}

