/*
 * Decompiled with CFR 0.152.
 */
package ow.routing;

import java.security.NoSuchProviderException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import ow.routing.RoutingServiceProvider;
import ow.routing.impl.IterativeRoutingDriverProvider;
import ow.routing.impl.RecursiveRoutingDriverProvider;

public class RoutingServiceFactory {
    private static final Logger logger = Logger.getLogger("routing");
    private static final Class[] PROVIDERS = new Class[]{IterativeRoutingDriverProvider.class, RecursiveRoutingDriverProvider.class};
    private static final Map<String, RoutingServiceProvider> providerTable = new HashMap<String, RoutingServiceProvider>();
    private static final Map<String, Integer> idTable = new HashMap<String, Integer>();

    public static RoutingServiceProvider getProvider(String routingStyle) throws NoSuchProviderException {
        RoutingServiceProvider provider = providerTable.get(routingStyle);
        if (provider == null) {
            throw new NoSuchProviderException("No such routing style: " + routingStyle);
        }
        return provider;
    }

    public static byte getRoutingStyleID(String routingStyle) throws NoSuchProviderException {
        Integer idInteger = idTable.get(routingStyle);
        if (idInteger == null) {
            throw new NoSuchProviderException("No such routing style: " + routingStyle);
        }
        return (byte)idInteger.intValue();
    }

    static {
        int id = 1;
        for (Class clazz : PROVIDERS) {
            Object o;
            try {
                o = clazz.newInstance();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Could not instantiate an object of the class: " + clazz, e);
                continue;
            }
            if (!(o instanceof RoutingServiceProvider)) continue;
            RoutingServiceProvider provider = (RoutingServiceProvider)o;
            idTable.put(provider.getName(), id);
            ++id;
            providerTable.put(provider.getName(), provider);
        }
    }
}

