/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.dhtshell.commands;

import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import ow.dht.ByteArray;
import ow.dht.DHT;
import ow.dht.ValueInfo;
import ow.id.ID;
import ow.id.IDUtility;
import ow.tool.util.shellframework.Command;
import ow.tool.util.shellframework.CommandUtil;
import ow.tool.util.shellframework.ShellContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RemoveCommand
implements Command<DHT<String>> {
    private static final String[] NAMES = new String[]{"remove", "delete"};

    @Override
    public String[] getNames() {
        return NAMES;
    }

    @Override
    public String getHelp() {
        return "remove|delete [-status] <secret> <key> [<value> ...] [- <key> [<value> ...] ...]";
    }

    @Override
    public boolean execute(ShellContext<DHT<String>> context) {
        DHT<String> dht = context.getOpaqueData();
        PrintStream out = context.getOutputStream();
        String[] args = context.getArguments();
        boolean showStatus = false;
        ConcurrentLinkedQueue requestQueue = new ConcurrentLinkedQueue();
        int argIndex = 0;
        if (argIndex < args.length && args[argIndex].startsWith("-")) {
            showStatus = true;
            ++argIndex;
        }
        if (args.length < argIndex + 2) {
            out.print("usage: " + this.getHelp() + "\r\n");
            out.flush();
            return false;
        }
        ByteArray secret = null;
        try {
            secret = ByteArray.valueOf(args[argIndex], "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        ++argIndex;
        secret = secret.hashWithSHA1();
        do {
            int nargs = args.length - argIndex;
            for (int j = 1; j < nargs; ++j) {
                if (!"-".equals(args[argIndex + j])) continue;
                nargs = j;
            }
            ID key = IDUtility.parseID(args[argIndex], dht.getRoutingAlgorithmConfiguration().getIDSizeInByte());
            int nValue = nargs - 1;
            if (nValue > 0) {
                String[] values = new String[nValue];
                for (int j = 0; j < nValue; ++j) {
                    values[j] = args[argIndex + 1 + j];
                }
                requestQueue.offer(new DHT.RemoveRequest<String>(key, values));
            } else {
                requestQueue.offer(new DHT.RemoveRequest(key));
            }
            argIndex += nargs;
            while (argIndex < args.length && "-".equals(args[argIndex])) {
                ++argIndex;
            }
        } while (argIndex < args.length);
        DHT.RemoveRequest[] requests = new DHT.RemoveRequest[requestQueue.size()];
        for (argIndex = 0; argIndex < requests.length; ++argIndex) {
            requests[argIndex] = (DHT.RemoveRequest)requestQueue.poll();
        }
        Set<ValueInfo<String>>[] values = dht.remove(requests, secret);
        StringBuilder sb = new StringBuilder();
        for (argIndex = 0; argIndex < requests.length; ++argIndex) {
            sb.append("key:   ").append(requests[argIndex].getKey()).append("\r\n");
            if (values[argIndex] != null) {
                for (ValueInfo<String> v : values[argIndex]) {
                    sb.append("value: ").append(v.getValue()).append(" ").append(v.getTTL() / 1000L);
                    secret = v.getHashedSecret();
                    if (secret != null) {
                        sb.append(" ").append(secret);
                    }
                    sb.append("\r\n");
                }
                continue;
            }
            sb.append("value:").append("\r\n");
        }
        if (showStatus) {
            sb.append((CharSequence)CommandUtil.buildStatusMessage(context.getOpaqueData(), -1));
        }
        out.print(sb);
        out.flush();
        return false;
    }
}

