/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.memcached.commands;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Set;
import ow.dht.ValueInfo;
import ow.dht.memcached.Item;
import ow.dht.memcached.Memcached;
import ow.id.ID;
import ow.id.IDUtility;
import ow.tool.util.shellframework.Command;
import ow.tool.util.shellframework.ShellContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractSetCommand
implements Command<Memcached> {
    AbstractSetCommand() {
    }

    public boolean set(ShellContext<Memcached> context, Memcached.Condition cond) {
        byte[] dataBlock;
        int bytes;
        long exptime;
        int flags;
        Memcached dht = context.getOpaqueData();
        PrintStream out = context.getOutputStream();
        String[] args = context.getArguments();
        boolean isCas = cond.equals((Object)Memcached.Condition.CAS);
        if (isCas && (args.length < 5 || args.length > 6) || args.length < 4 || args.length > 5) {
            out.print("ERROR\r\n");
            out.flush();
            return false;
        }
        ID key = IDUtility.parseID(args[0], dht.getRoutingAlgorithmConfiguration().getIDSizeInByte());
        try {
            flags = (int)Long.parseLong(args[1]);
            exptime = Long.parseLong(args[2]);
            bytes = Integer.parseInt(args[3]);
        }
        catch (NumberFormatException e) {
            out.print("CLIENT_ERROR bad command line format\r\n");
            out.flush();
            return false;
        }
        int argIndex = 4;
        int casUnique = 0;
        if (isCas) {
            casUnique = (int)Long.parseLong(args[argIndex++]);
        }
        boolean noreply = false;
        if (args.length > argIndex && args[argIndex].toLowerCase().equals("noreply")) {
            noreply = true;
        }
        try {
            dataBlock = context.getShell().readLine(bytes);
        }
        catch (IOException e) {
            return true;
        }
        if (dataBlock == null || dataBlock.length != bytes) {
            out.print("CLIENT_ERROR bad data chunk\r\n");
            out.flush();
            return false;
        }
        if ((exptime *= 1000L) <= 0L) {
            exptime = dht.getConfiguration().getDefaultTTL();
        }
        dht.setTTLForPut(exptime);
        Item item = new Item(dataBlock, flags);
        Set<ValueInfo<Item>> existedValue = null;
        try {
            existedValue = isCas ? dht.put(key, item, casUnique) : dht.put(key, item, cond);
        }
        catch (Exception e) {
            out.print("SERVER_ERROR put failed\r\n");
            out.flush();
            return false;
        }
        if (!noreply) {
            if (isCas) {
                if (existedValue != null) {
                    if (existedValue.isEmpty()) {
                        out.print("EXISTS\r\n");
                    } else {
                        out.print("STORED\r\n");
                    }
                } else {
                    out.print("NOT_FOUND\r\n");
                }
            } else if (existedValue != null) {
                out.print("STORED\r\n");
            } else {
                out.print("NOT_STORED\r\n");
            }
            out.flush();
        }
        return false;
    }
}

