/*
 * Decompiled with CFR 0.152.
 */
package ow.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import ow.util.concurrent.GlobalThreadPoolExecutors;

public final class Timer {
    static final Logger logger = Logger.getLogger("util");
    public static final boolean TERMINATE_THREADS_IF_NO_TASK = true;
    public static final boolean USE_THREAD_POOL = true;
    public static final boolean ADAPT_TIMER_TO_OVERLOAD_AND_CLOCK_JUMP = true;
    public static final long MAX_JUMP_WIDTH = 1000L;
    public static final long ADDITIONAL_WAIT = 50L;
    private SortedSet<ScheduledTask> taskSet;
    private Map<Runnable, ScheduledTask> taskTable;
    private int numNonDaemonTask;
    private TimerRunner timerRunner;
    private Set<Thread> timerThreadSet = new HashSet<Thread>();
    private String timerThreadName;
    private boolean isDaemon;
    private int timerThreadPriority;
    private int numThreads = 0;
    private long deferredTime = 0L;

    public Timer() {
        this("Timer thread", false);
    }

    public Timer(String threadName, boolean isDaemon) {
        this(threadName, isDaemon, Thread.currentThread().getPriority());
    }

    public Timer(String threadName, boolean isDaemon, int threadPriority) {
        this.timerThreadName = threadName;
        this.isDaemon = isDaemon;
        this.timerThreadPriority = threadPriority;
        if (this.timerThreadPriority > 10) {
            this.timerThreadPriority = 10;
        } else if (this.timerThreadPriority < 1) {
            this.timerThreadPriority = 1;
        }
        this.taskSet = new TreeSet<ScheduledTask>();
        this.taskTable = new HashMap<Runnable, ScheduledTask>();
        this.numNonDaemonTask = 0;
        this.timerRunner = new TimerRunner();
    }

    private synchronized void startAThread() {
        if (this.numThreads < 1) {
            Thread t = new Thread(this.timerRunner);
            t.setName(this.timerThreadName);
            t.setDaemon(this.isDaemon);
            try {
                t.setPriority(this.timerThreadPriority);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Could not set thread priority: " + this.timerThreadPriority, e);
            }
            t.start();
            ++this.numThreads;
            this.timerThreadSet.add(t);
        }
    }

    private synchronized void interruptAThread() {
        for (Thread t : this.timerThreadSet) {
            t.interrupt();
        }
    }

    public void schedule(Runnable r, long absoluteTime) {
        this.schedule(r, absoluteTime, false, false);
    }

    public void schedule(Runnable r, long absoluteTime, boolean isDaemon) {
        this.schedule(r, absoluteTime, isDaemon, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(Runnable r, long absoluteTime, boolean isDaemon, boolean executeConcurrently) {
        ScheduledTask task = new ScheduledTask(r, absoluteTime, 0L, isDaemon, executeConcurrently);
        SortedSet<ScheduledTask> sortedSet = this.taskSet;
        synchronized (sortedSet) {
            this.taskSet.add(task);
            this.taskTable.put(r, task);
            if (!isDaemon) {
                ++this.numNonDaemonTask;
            }
            this.taskSet.notify();
        }
        this.interruptAThread();
        this.startAThread();
    }

    public void scheduleAtFixedRate(Runnable r, long absoluteTime, long interval) {
        this.scheduleAtFixedRate(r, absoluteTime, interval, false, false);
    }

    public void scheduleAtFixedRate(Runnable r, long absoluteTime, long interval, boolean isDaemon) {
        this.scheduleAtFixedRate(r, absoluteTime, interval, isDaemon, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleAtFixedRate(Runnable r, long absoluteTime, long interval, boolean isDaemon, boolean executeConcurrently) {
        ScheduledTask task = new ScheduledTask(r, absoluteTime, interval, isDaemon, executeConcurrently);
        SortedSet<ScheduledTask> sortedSet = this.taskSet;
        synchronized (sortedSet) {
            this.taskSet.add(task);
            this.taskTable.put(r, task);
            if (!isDaemon) {
                ++this.numNonDaemonTask;
            }
            this.taskSet.notify();
        }
        this.interruptAThread();
        this.startAThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel(Runnable r) {
        boolean scheduled = false;
        SortedSet<ScheduledTask> sortedSet = this.taskSet;
        synchronized (sortedSet) {
            ScheduledTask task = this.taskTable.get(r);
            if (task != null) {
                this.taskSet.remove(task);
                this.taskTable.remove(task.getTask());
                if (!task.isDaemon) {
                    --this.numNonDaemonTask;
                }
                scheduled = true;
            }
        }
        this.interruptAThread();
        return scheduled;
    }

    public long getScheduledTime(Runnable r) {
        ScheduledTask task = this.taskTable.get(r);
        if (task != null) {
            return task.getScheduledTime();
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.timerRunner.stop();
        Class<Timer> clazz = Timer.class;
        synchronized (Timer.class) {
            for (Thread t : this.timerThreadSet) {
                t.interrupt();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public synchronized long getDeferredTime() {
        return this.deferredTime;
    }

    private class TimerRunner
    implements Runnable {
        private boolean stopped = false;

        private TimerRunner() {
        }

        public void stop() {
            this.stopped = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block21: while (true) {
                ScheduledTask currentTask;
                block31: {
                    currentTask = null;
                    do {
                        long excessiveSleepPeriod;
                        SortedSet sortedSet = Timer.this.taskSet;
                        synchronized (sortedSet) {
                            if (!Timer.this.isDaemon && Timer.this.numNonDaemonTask <= 0) {
                                break block21;
                            }
                            try {
                                currentTask = (ScheduledTask)Timer.this.taskSet.first();
                            }
                            catch (NoSuchElementException e) {
                                break block21;
                            }
                        }
                        long sleepPeriod = currentTask.getScheduledTime() - System.currentTimeMillis();
                        if (sleepPeriod > 0L) {
                            try {
                                Thread.sleep(sleepPeriod);
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                            excessiveSleepPeriod = System.currentTimeMillis() - currentTask.getScheduledTime();
                        } else {
                            excessiveSleepPeriod = -sleepPeriod;
                        }
                        if (excessiveSleepPeriod > 1000L) {
                            System.out.println("[Clock jump or overload detected: " + currentTask.getTask().getClass() + " @ " + Integer.toHexString(System.identityHashCode(currentTask)) + ", " + excessiveSleepPeriod + " msec behind]");
                            System.out.flush();
                            excessiveSleepPeriod += 50L;
                            Object object = Timer.this;
                            synchronized (object) {
                                Timer.this.deferredTime += excessiveSleepPeriod;
                            }
                            object = Timer.this.taskSet;
                            synchronized (object) {
                                for (ScheduledTask t : Timer.this.taskSet) {
                                    t.deferScheduledTime(excessiveSleepPeriod);
                                }
                            }
                        }
                        if (excessiveSleepPeriod >= 0L) break block31;
                    } while (!this.stopped);
                    break;
                }
                Runnable r = currentTask.getTask();
                if (currentTask.executedConcurrently()) {
                    ExecutorService ex = GlobalThreadPoolExecutors.getThreadPool(false, true, currentTask.isDaemon());
                    ex.submit(r);
                } else {
                    try {
                        r.run();
                    }
                    catch (Throwable e) {
                        logger.log(Level.WARNING, "A task threw an exception: " + e, e);
                    }
                }
                SortedSet e = Timer.this.taskSet;
                synchronized (e) {
                    Timer.this.taskSet.remove(currentTask);
                    Timer.this.taskTable.remove(currentTask.getTask());
                    if (!currentTask.isDaemon) {
                        Timer.this.numNonDaemonTask--;
                    }
                }
                long interval = currentTask.getInterval();
                if (interval <= 0L) continue;
                Timer.this.scheduleAtFixedRate(r, currentTask.getScheduledTime() + interval, interval, currentTask.isDaemon(), currentTask.executedConcurrently());
            }
            Timer timer = Timer.this;
            synchronized (timer) {
                Timer.this.numThreads--;
                Timer.this.timerThreadSet.remove(Thread.currentThread());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ScheduledTask
    implements Comparable<ScheduledTask> {
        private final Runnable task;
        private long time;
        private final long interval;
        private boolean isDaemon;
        private final boolean executedConcurrently;

        private ScheduledTask(Runnable task, long absoluteTime, boolean isDaemon, boolean executedConcurrently) {
            this(task, absoluteTime, 0L, isDaemon, executedConcurrently);
        }

        private ScheduledTask(Runnable task, long absoluteTime, long interval, boolean isDaemon, boolean executedConcurrently) {
            this.task = task;
            this.time = absoluteTime;
            this.interval = interval;
            this.isDaemon = isDaemon;
            this.executedConcurrently = executedConcurrently;
        }

        protected Runnable getTask() {
            return this.task;
        }

        protected long getScheduledTime() {
            return this.time;
        }

        private void deferScheduledTime(long t) {
            this.time += t;
        }

        protected long getInterval() {
            return this.interval;
        }

        private boolean isDaemon() {
            return this.isDaemon;
        }

        private boolean executedConcurrently() {
            return this.executedConcurrently;
        }

        @Override
        public int compareTo(ScheduledTask o) {
            int order = Long.signum(this.time - o.time);
            if (order != 0) {
                return order;
            }
            order = System.identityHashCode(o) - System.identityHashCode(this);
            return order;
        }
    }
}

