package haskell.prelude;

import haskell.test.HaskellTestCase;

public class BoolTest extends HaskellTestCase {

    public void testValueOf() {
        assertFalse(Bool.valueOf(false));
        assertTrue (Bool.valueOf(true));
    }

    // ---- java.lang.Object

    public void testHashCode() {
        assertEquals(Boolean.FALSE.hashCode(), Bool.False().hashCode());
        assertEquals(Boolean.TRUE .hashCode(), Bool.True() .hashCode());
    }

    public void testEquals() {
        assertEquals(Bool.False(), new Bool(null, false));
        assertEquals(Bool.True(),  new Bool(null, true));
    }

    public void testToString() {
        assertEquals("False", Bool.False().toString());
        assertEquals("True",  Bool.True() .toString());
    }

    // ---- java.lang.Comparable

    public void testCompareTo() {
        assertTrue(Bool.False().compareTo(Bool.False()) == 0);
        assertTrue(Bool.False().compareTo(Bool.True())  <  0);
        assertTrue(Bool.True() .compareTo(Bool.False()) >  0);
        assertTrue(Bool.True() .compareTo(Bool.True())  == 0);
    }

    // ---- data Bool

    public void testFalse() {
        assertTrue (Bool.False().isFalse());
        assertFalse(Bool.False().isTrue());
    }

    public void testTrue() {
        assertFalse(Bool.True().isFalse());
        assertTrue (Bool.True().isTrue());
    }

    public void testAnd() {
        // Bool#and(Bool, Bool)
        assertFalse(Bool.and(Bool.False(), Bool.False()));
        assertFalse(Bool.and(Bool.False(), Bool.True()));
        assertFalse(Bool.and(Bool.True(),  Bool.False()));
        assertTrue (Bool.and(Bool.True(),  Bool.True()));
        // Bool#and()
        assertFalse(Bool.and().apply(Bool.False(), Bool.False()));
        assertFalse(Bool.and().apply(Bool.False(), Bool.True()));
        assertFalse(Bool.and().apply(Bool.True(),  Bool.False()));
        assertTrue (Bool.and().apply(Bool.True(),  Bool.True()));
        // Bool#_and_(Bool)
        assertFalse(Bool.False()._and_(Bool.False()));
        assertFalse(Bool.False()._and_(Bool.True()));
        assertFalse(Bool.True() ._and_(Bool.False()));
        assertTrue (Bool.True() ._and_(Bool.True()));
        // Bool#apply(and)
        assertFalse(Bool.False().apply(Bool.and()).apply(Bool.False()));
        assertFalse(Bool.False().apply(Bool.and()).apply(Bool.True()));
        assertFalse(Bool.True() .apply(Bool.and()).apply(Bool.False()));
        assertTrue (Bool.True() .apply(Bool.and()).apply(Bool.True()));
    }

    public void testOr() {
        // Bool#or(Bool, Bool)
        assertFalse(Bool.or(Bool.False(), Bool.False()));
        assertTrue (Bool.or(Bool.False(), Bool.True()));
        assertTrue (Bool.or(Bool.True(),  Bool.False()));
        assertTrue (Bool.or(Bool.True(),  Bool.True()));
        // Bool#or()
        assertFalse(Bool.or().apply(Bool.False(), Bool.False()));
        assertTrue (Bool.or().apply(Bool.False(), Bool.True()));
        assertTrue (Bool.or().apply(Bool.True(),  Bool.False()));
        assertTrue (Bool.or().apply(Bool.True(),  Bool.True()));
        // Bool#_or_(Bool)
        assertFalse(Bool.False()._or_(Bool.False()));
        assertTrue (Bool.False()._or_(Bool.True()));
        assertTrue (Bool.True() ._or_(Bool.False()));
        assertTrue (Bool.True() ._or_(Bool.True()));
        // Bool#apply(or)
        assertFalse(Bool.False().apply(Bool.or()).apply(Bool.False()));
        assertTrue (Bool.False().apply(Bool.or()).apply(Bool.True()));
        assertTrue (Bool.True() .apply(Bool.or()).apply(Bool.False()));
        assertTrue (Bool.True() .apply(Bool.or()).apply(Bool.True()));
    }

    public void testNot() {
        // Bool#not(Bool)
        assertTrue (Bool.not(Bool.False()));
        assertFalse(Bool.not(Bool.True()));
        // Bool#not()
        assertTrue (Bool.not().apply(Bool.False()));
        assertFalse(Bool.not().apply(Bool.True()));
        // Bool#apply(not)
        assertTrue (Bool.False().apply(Bool.not()));
        assertFalse(Bool.True() .apply(Bool.not()));
    }

    public void testOtherwise() {
        // Bool#otherwise()
        assertTrue(Bool.otherwise());
    }

    // ---- instance Show Bool

    public void testShow() {
        // Bool#show(Bool)
        assertEquals("False", Bool.show(Bool.False()));
        assertEquals("True",  Bool.show(Bool.True()));
        // Bool#show()
        assertEquals("False", Bool.Show().show().apply(Bool.False()));
        assertEquals("True",  Bool.Show().show().apply(Bool.True()));
    }

    // ---- instance Eq Bool

    public void testEq() {
        // Bool#Eq().eq(Bool, Bool)
        assertTrue (Bool.Eq().eq(Bool.False(), Bool.False()));
        assertFalse(Bool.Eq().eq(Bool.False(), Bool.True()));
        assertFalse(Bool.Eq().eq(Bool.True(),  Bool.False()));
        assertTrue (Bool.Eq().eq(Bool.True(),  Bool.True()));
        // Bool#Eq().eq()
        assertTrue (Bool.Eq().eq().apply(Bool.False(), Bool.False()));
        assertFalse(Bool.Eq().eq().apply(Bool.False(), Bool.True()));
        assertFalse(Bool.Eq().eq().apply(Bool.True(),  Bool.False()));
        assertTrue (Bool.Eq().eq().apply(Bool.True(),  Bool.True()));
        // Bool#_eq_(Bool)
        assertTrue (Bool.False()._eq_(Bool.False()));
        assertFalse(Bool.False()._eq_(Bool.True()));
        assertFalse(Bool.True() ._eq_(Bool.False()));
        assertTrue (Bool.True() ._eq_(Bool.True()));
        // Bool#apply(eq)
        assertTrue (Bool.False().apply(Bool.Eq().eq()).apply(Bool.False()));
        assertFalse(Bool.False().apply(Bool.Eq().eq()).apply(Bool.True()));
        assertFalse(Bool.True() .apply(Bool.Eq().eq()).apply(Bool.False()));
        assertTrue (Bool.True() .apply(Bool.Eq().eq()).apply(Bool.True()));
    }

    public void testNe() {
        // Bool#Eq().ne(Bool, Bool)
        assertFalse(Bool.Eq().ne(Bool.False(), Bool.False()));
        assertTrue (Bool.Eq().ne(Bool.False(), Bool.True()));
        assertTrue (Bool.Eq().ne(Bool.True(),  Bool.False()));
        assertFalse(Bool.Eq().ne(Bool.True(),  Bool.True()));
        // Bool#Eq().ne()
        assertFalse(Bool.Eq().ne().apply(Bool.False(), Bool.False()));
        assertTrue (Bool.Eq().ne().apply(Bool.False(), Bool.True()));
        assertTrue (Bool.Eq().ne().apply(Bool.True(),  Bool.False()));
        assertFalse(Bool.Eq().ne().apply(Bool.True(),  Bool.True()));
        // Bool#_ne_(Bool)
        assertFalse(Bool.False()._ne_(Bool.False()));
        assertTrue (Bool.False()._ne_(Bool.True()));
        assertTrue (Bool.True() ._ne_(Bool.False()));
        assertFalse(Bool.True() ._ne_(Bool.True()));
        // Bool#apply(ne)
        assertFalse(Bool.False().apply(Bool.Eq().ne()).apply(Bool.False()));
        assertTrue (Bool.False().apply(Bool.Eq().ne()).apply(Bool.True()));
        assertTrue (Bool.True() .apply(Bool.Eq().ne()).apply(Bool.False()));
        assertFalse(Bool.True() .apply(Bool.Eq().ne()).apply(Bool.True()));
    }

    // ---- instnace Ord Bool

    public void testLt() {
        // Bool#Ord().lt(Bool, Bool)
        assertFalse(Bool.Ord().lt(Bool.False(), Bool.False()));
        assertTrue (Bool.Ord().lt(Bool.False(), Bool.True()));
        assertFalse(Bool.Ord().lt(Bool.True(),  Bool.False()));
        assertFalse(Bool.Ord().lt(Bool.True(),  Bool.True()));
        // Bool#Ord().lt()
        assertFalse(Bool.Ord().lt().apply(Bool.False(), Bool.False()));
        assertTrue (Bool.Ord().lt().apply(Bool.False(), Bool.True()));
        assertFalse(Bool.Ord().lt().apply(Bool.True(),  Bool.False()));
        assertFalse(Bool.Ord().lt().apply(Bool.True(),  Bool.True()));
        // Bool#_lt_(Bool)
        assertFalse(Bool.False()._lt_(Bool.False()));
        assertTrue (Bool.False()._lt_(Bool.True()));
        assertFalse(Bool.True() ._lt_(Bool.False()));
        assertFalse(Bool.True() ._lt_(Bool.True()));
        // Bool#apply(lt)
        assertFalse(Bool.False().apply(Bool.Ord().lt()).apply(Bool.False()));
        assertTrue (Bool.False().apply(Bool.Ord().lt()).apply(Bool.True()));
        assertFalse(Bool.True() .apply(Bool.Ord().lt()).apply(Bool.False()));
        assertFalse(Bool.True() .apply(Bool.Ord().lt()).apply(Bool.True()));
    }

    public void testLe() {
        // Bool#Ord().le(Bool, Bool)
        assertTrue (Bool.Ord().le(Bool.False(), Bool.False()));
        assertTrue (Bool.Ord().le(Bool.False(), Bool.True()));
        assertFalse(Bool.Ord().le(Bool.True(),  Bool.False()));
        assertTrue (Bool.Ord().le(Bool.True(),  Bool.True()));
        // Bool#Ord().le()
        assertTrue (Bool.Ord().le().apply(Bool.False(), Bool.False()));
        assertTrue (Bool.Ord().le().apply(Bool.False(), Bool.True()));
        assertFalse(Bool.Ord().le().apply(Bool.True(),  Bool.False()));
        assertTrue (Bool.Ord().le().apply(Bool.True(),  Bool.True()));
        // Bool#_le_(Bool)
        assertTrue (Bool.False()._le_(Bool.False()));
        assertTrue (Bool.False()._le_(Bool.True()));
        assertFalse(Bool.True() ._le_(Bool.False()));
        assertTrue (Bool.True() ._le_(Bool.True()));
        // Bool#apply(le)
        assertTrue (Bool.False().apply(Bool.Ord().le()).apply(Bool.False()));
        assertTrue (Bool.False().apply(Bool.Ord().le()).apply(Bool.True()));
        assertFalse(Bool.True() .apply(Bool.Ord().le()).apply(Bool.False()));
        assertTrue (Bool.True() .apply(Bool.Ord().le()).apply(Bool.True()));
    }

    public void testGt() {
        // Bool#Ord().gt(Bool, Bool)
        assertFalse(Bool.Ord().gt(Bool.False(), Bool.False()));
        assertFalse(Bool.Ord().gt(Bool.False(), Bool.True()));
        assertTrue (Bool.Ord().gt(Bool.True(),  Bool.False()));
        assertFalse(Bool.Ord().gt(Bool.True(),  Bool.True()));
        // Bool#Ord().gt()
        assertFalse(Bool.Ord().gt().apply(Bool.False(), Bool.False()));
        assertFalse(Bool.Ord().gt().apply(Bool.False(), Bool.True()));
        assertTrue (Bool.Ord().gt().apply(Bool.True(),  Bool.False()));
        assertFalse(Bool.Ord().gt().apply(Bool.True(),  Bool.True()));
        // Bool#_gt_(Bool)
        assertFalse(Bool.False()._gt_(Bool.False()));
        assertFalse(Bool.False()._gt_(Bool.True()));
        assertTrue (Bool.True() ._gt_(Bool.False()));
        assertFalse(Bool.True() ._gt_(Bool.True()));
        // Bool#apply(gt)
        assertFalse(Bool.False().apply(Bool.Ord().gt()).apply(Bool.False()));
        assertFalse(Bool.False().apply(Bool.Ord().gt()).apply(Bool.True()));
        assertTrue (Bool.True() .apply(Bool.Ord().gt()).apply(Bool.False()));
        assertFalse(Bool.True() .apply(Bool.Ord().gt()).apply(Bool.True()));
    }

    public void testGe() {
        // Bool#Ord().ge(Bool, Bool)
        assertTrue (Bool.Ord().ge(Bool.False(), Bool.False()));
        assertFalse(Bool.Ord().ge(Bool.False(), Bool.True()));
        assertTrue (Bool.Ord().ge(Bool.True(),  Bool.False()));
        assertTrue (Bool.Ord().ge(Bool.True(),  Bool.True()));
        // Bool#Ord().ge()
        assertTrue (Bool.Ord().ge().apply(Bool.False(), Bool.False()));
        assertFalse(Bool.Ord().ge().apply(Bool.False(), Bool.True()));
        assertTrue (Bool.Ord().ge().apply(Bool.True(),  Bool.False()));
        assertTrue (Bool.Ord().ge().apply(Bool.True(),  Bool.True()));
        // Bool#_ge_(Bool)
        assertTrue (Bool.False()._ge_(Bool.False()));
        assertFalse(Bool.False()._ge_(Bool.True()));
        assertTrue (Bool.True() ._ge_(Bool.False()));
        assertTrue (Bool.True() ._ge_(Bool.True()));
        // Bool#apply(ge)
        assertTrue (Bool.False().apply(Bool.Ord().ge()).apply(Bool.False()));
        assertFalse(Bool.False().apply(Bool.Ord().ge()).apply(Bool.True()));
        assertTrue (Bool.True() .apply(Bool.Ord().ge()).apply(Bool.False()));
        assertTrue (Bool.True() .apply(Bool.Ord().ge()).apply(Bool.True()));
    }

    public void testCompare() {
        // Bool#Ord().compare(Bool, Bool)
        assertEQ(Bool.Ord().compare(Bool.False(), Bool.False()));
        assertLT(Bool.Ord().compare(Bool.False(), Bool.True()));
        assertGT(Bool.Ord().compare(Bool.True(),  Bool.False()));
        assertEQ(Bool.Ord().compare(Bool.True(),  Bool.True()));
        // Bool#Ord().comapre()
        assertEQ(Bool.Ord().compare().apply(Bool.False(), Bool.False()));
        assertLT(Bool.Ord().compare().apply(Bool.False(), Bool.True()));
        assertGT(Bool.Ord().compare().apply(Bool.True(),  Bool.False()));
        assertEQ(Bool.Ord().compare().apply(Bool.True(),  Bool.True()));
        // Bool#apply(comapre)
        assertEQ(Bool.False().apply(Bool.Ord().compare()).apply(Bool.False()));
        assertLT(Bool.False().apply(Bool.Ord().compare()).apply(Bool.True()));
        assertGT(Bool.True() .apply(Bool.Ord().compare()).apply(Bool.False()));
        assertEQ(Bool.True() .apply(Bool.Ord().compare()).apply(Bool.True()));
    }

    public void testMin() {
        // Bool#Ord().min(Bool, Bool)
        assertFalse(Bool.Ord().min(Bool.False(), Bool.False()));
        assertFalse(Bool.Ord().min(Bool.False(), Bool.True()));
        assertFalse(Bool.Ord().min(Bool.True(),  Bool.False()));
        assertTrue (Bool.Ord().min(Bool.True(),  Bool.True()));
        // Bool#Ord().min()
        assertFalse(Bool.Ord().min().apply(Bool.False(), Bool.False()));
        assertFalse(Bool.Ord().min().apply(Bool.False(), Bool.True()));
        assertFalse(Bool.Ord().min().apply(Bool.True(),  Bool.False()));
        assertTrue (Bool.Ord().min().apply(Bool.True(),  Bool.True()));
        // Bool#apply(min)
        assertFalse(Bool.False().apply(Bool.Ord().min()).apply(Bool.False()));
        assertFalse(Bool.False().apply(Bool.Ord().min()).apply(Bool.True()));
        assertFalse(Bool.True() .apply(Bool.Ord().min()).apply(Bool.False()));
        assertTrue (Bool.True() .apply(Bool.Ord().min()).apply(Bool.True()));
    }

    public void testMax() {
        // Bool#Ord().max(Bool, Bool)
        assertFalse(Bool.Ord().max(Bool.False(), Bool.False()));
        assertTrue (Bool.Ord().max(Bool.False(), Bool.True()));
        assertTrue (Bool.Ord().max(Bool.True(),  Bool.False()));
        assertTrue (Bool.Ord().max(Bool.True(),  Bool.True()));
        // Bool#Ord().max()
        assertFalse(Bool.Ord().max().apply(Bool.False(), Bool.False()));
        assertTrue (Bool.Ord().max().apply(Bool.False(), Bool.True()));
        assertTrue (Bool.Ord().max().apply(Bool.True(),  Bool.False()));
        assertTrue (Bool.Ord().max().apply(Bool.True(),  Bool.True()));
        // Bool#apply(max)
        assertFalse(Bool.False().apply(Bool.Ord().max()).apply(Bool.False()));
        assertTrue (Bool.False().apply(Bool.Ord().max()).apply(Bool.True()));
        assertTrue (Bool.True() .apply(Bool.Ord().max()).apply(Bool.False()));
        assertTrue (Bool.True() .apply(Bool.Ord().max()).apply(Bool.True()));
    }

    // ---- instance Enum Bool

    public void testToEnum() {
        // Bool#Enum().toEnum(Int)
        assertTrue (Bool.Enum().toEnum(Int.valueOf(-1)));
        assertFalse(Bool.Enum().toEnum(Int.valueOf(0)));
        assertTrue (Bool.Enum().toEnum(Int.valueOf(1)));
        assertTrue (Bool.Enum().toEnum(Int.valueOf(2)));
        // Bool#Enum().toEnum()
    }

    public void testFromEnum() {
        // Bool#Enum().fromEnum(Bool)
        assertEquals(0, Bool.Enum().fromEnum(Bool.False()));
        assertEquals(1, Bool.Enum().fromEnum(Bool.True()));
    }

    // ---- instance Bounded Bool

    public void testMinBound() {
        // Bool#Bounded().minBound()
        assertFalse(Bool.Bounded().minBound());
    }

    public void testMaxBound() {
        // Bool#Bounded().maxBound()
        assertTrue (Bool.Bounded().maxBound());
    }

}
