package example.common.exception;

public class ApplicationException extends Exception {

    private static final long serialVersionUID = 241751331185076317L;

    private boolean rollbackOnly = false;

    public ApplicationException() {
    }

    public ApplicationException(String message) {
        super(message);
    }

    public ApplicationException(Throwable cause) {
        super(cause);
    }

    public ApplicationException(String message, Throwable cause) {
        super(message, cause);
    }

    public boolean isRollbackOnly() {
        return rollbackOnly;
    }

    public ApplicationException setRollbackOnly() {
        setRollbackOnly(true);
        return this;
    }

    public ApplicationException setRollbackOnly(boolean rollbackOnly) {
        this.rollbackOnly = rollbackOnly;
        return this;
    }

    @Override
    public String getMessage() {
        return super.getMessage()
                + "; rollbackOnly=" + rollbackOnly;
    }

}
