package example.hello.dto;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;

import example.common.util.ExampleUtils;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(namespace = "http://dto.hello.example/")
public class HelloRequest implements Serializable {

    private static final long serialVersionUID = 1L;

    private String name;

    public HelloRequest() {
    }

    public HelloRequest(String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String toString() {
        return ExampleUtils.fromBeanToString(this);
    }

}
