package example.hello.dto;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;

import example.common.util.ExampleUtils;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(namespace = "http://dto.hello.example/")
public class HelloResponse implements Serializable {

    private static final long serialVersionUID = 1L;

    private String message;

    public HelloResponse() {
    }

    public HelloResponse(String message) {
        this.message = message;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public String toString() {
        return ExampleUtils.fromBeanToString(this);
    }

}
