package example.hello.service;

import javax.ejb.Local;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;

import example.hello.dto.HelloRequest;
import example.hello.dto.HelloResponse;
import example.hello.exception.HelloException;
import example.hello.exception.HelloRuntimeException;

/**
 * Local インタフェースの例です。
 * 
 * @author glad
 */
@Local
@WebService(targetNamespace = "http://ws.service.hello.example/")
public interface HelloService {

    @WebMethod
    @WebResult(name = "result")
    HelloResponse sayHello(
            @WebParam(name = "request") HelloRequest request)
            throws HelloException, HelloRuntimeException;

}
