package example.org.seasar.framework.convention.impl;

import org.seasar.framework.convention.impl.NamingConventionImpl;

import example.org.seasar.framework.convention.ExampleNamingConvention;

public class ExampleNamingConventionImpl extends NamingConventionImpl
        implements ExampleNamingConvention {

    private String managerSuffix = "Mgr";

    private String managerPackageName = "manager";

    private String implementationPackageName = "impl";

    public ExampleNamingConventionImpl() {
        setImplementationSuffix("Bean");
    }

    public String getManagerSuffix() {
        return managerSuffix;
    }

    public void setManagerSuffix(String managerSuffix) {
        this.managerSuffix = managerSuffix;
    }

    public String getManagerPackageName() {
        return managerPackageName;
    }

    public void setManagerPackageName(String managerPackageName) {
        this.managerPackageName = managerPackageName;
    }

    @Override
    public String getImplementationPackageName() {
        return implementationPackageName;
    }

    public void setImplementationPackageName(String implementationPackageName) {
        this.implementationPackageName = implementationPackageName;
    }

    @Override
    public String fromSuffixToPackageName(final String suffix) {
        if (managerSuffix.equals(suffix)) {
            return getManagerPackageName();
        }
        return super.fromSuffixToPackageName(suffix);
    }

    @Override
    protected boolean isSubApplicationSuffix(final String suffix) {
        if (managerSuffix.equals(suffix)) {
            return true;
        }
        return super.isSubApplicationSuffix(suffix);
    }

}
