package jp.sourceforge.glad.collection;

import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Random;


public class ArrayAdapter<E> extends ListAdapter<E> {

    public ArrayAdapter(Object o) {
        this(new FixedList<E>(o));
    }

    public ArrayAdapter(E... array) {
        this(new FixedList<E>(array));
    }

    public ArrayAdapter(Class<?> componentType, int length) {
        this(new FixedList<E>(componentType, length));
    }

    ArrayAdapter(FixedList<E> list) {
        super(list);
    }

    public FixedList<E> collection() {
        return list();
    }

    public FixedList<E> list() {
        return (FixedList<E>) collection;
    }

    public <A> A array() {
        return list().<A>array();
    }

    public int length() {
        return list().length();
    }

    public E get(int index) {
        return super.get(index);
    }

    public boolean getBoolean(int index) {
        return list().getBoolean(index);
    }

    public char getChar(int index) {
        return list().getChar(index);
    }

    public byte getByte(int index) {
        return list().getByte(index);
    }

    public short getShort(int index) {
        return list().getShort(index);
    }

    public int getInt(int index) {
        return list().getInt(index);
    }

    public long getLong(int index) {
        return list().getLong(index);
    }

    public float getFloat(int index) {
        return list().getFloat(index);
    }

    public double getDouble(int index) {
        return list().getDouble(index);
    }

    public ArrayAdapter<E> set(int index, E value) {
        super.set(index, value);
        return this;
    }

    public ArrayAdapter<E> setBoolean(int index, boolean value) {
        list().setBoolean(index, value);
        return this;
    }

    public ArrayAdapter<E> setChar(int index, char value) {
        list().setChar(index, value);
        return this;
    }

    public ArrayAdapter<E> setByte(int index, byte value) {
        list().setByte(index, value);
        return this;
    }

    public ArrayAdapter<E> setShort(int index, short value) {
        list().setShort(index, value);
        return this;
    }

    public ArrayAdapter<E> setInt(int index, int value) {
        list().setInt(index, value);
        return this;
    }

    public ArrayAdapter<E> setLong(int index, long value) {
        list().setLong(index, value);
        return this;
    }

    public ArrayAdapter<E> setFloat(int index, float value) {
        list().setFloat(index, value);
        return this;
    }

    public ArrayAdapter<E> setDouble(int index, double value) {
        list().setDouble(index, value);
        return this;
    }

    // this ∪ {o}

    @Deprecated
    public ArrayAdapter<E> add(E o) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public ArrayAdapter<E> add(int index, E o) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public ArrayAdapter<E> addN(int n, E o) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public ArrayAdapter<E> addN(int index, int n, E o) {
        throw new UnsupportedOperationException();
    }

    // this ∪ c

    @Deprecated
    public ArrayAdapter<E> addAll(E... a) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public ArrayAdapter<E> addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public ArrayAdapter<E> addAll(CollectionAdapter<? extends E> ca) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public ArrayAdapter<E> addAll(Iterable<? extends E> i) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public ArrayAdapter<E> addAll(Iterator<? extends E> i) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public ArrayAdapter<E> addAll(Enumeration<? extends E> e) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public ArrayAdapter<E> addAll(int index, E... a) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public ArrayAdapter<E> addAll(int index, Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public ArrayAdapter<E> addAll(
            int index, CollectionAdapter<? extends E> ca) {
        throw new UnsupportedOperationException();
    }

    // this - {c}

    @Deprecated
    public ArrayAdapter<E> remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public ArrayAdapter<E> remove(Object o) {
        throw new UnsupportedOperationException();
    }

    // this - c

    @Deprecated
    public ArrayAdapter<E> removeAll(Object... a) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public ArrayAdapter<E> removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public ArrayAdapter<E> removeAll(CollectionAdapter<?> ca) {
        throw new UnsupportedOperationException();
    }

    // this ∩ c

    @Deprecated
    public ArrayAdapter<E> retainAll(E... a) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public ArrayAdapter<E> retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public ArrayAdapter<E> retainAll(CollectionAdapter<? extends E> ca) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public ArrayAdapter<E> clear() {
        throw new UnsupportedOperationException();
    }

    public ArrayAdapter<E> sort() {
        super.sort();
        return this;
    }

    public ArrayAdapter<E> sort(Comparator<E> comparator) {
        super.sort(comparator);
        return this;
    }

    public ArrayAdapter<E> reverse() {
        super.reverse();
        return this;
    }

    public ArrayAdapter<E> shuffle() {
        super.shuffle();
        return this;
    }

    public ArrayAdapter<E> shuffle(Random random) {
        super.shuffle(random);
        return this;
    }

    public ArrayAdapter<E> swap(int i, int j) {
        super.swap(i, j);
        return this;
    }

    public ArrayAdapter<E> fill(E o) {
        super.fill(o);
        return this;
    }

    public ArrayAdapter<E> copyFrom(List<? extends E> source) {
        super.copyFrom(source);
        return this;
    }

    public ArrayAdapter<E> copyTo(List<? super E> target) {
        super.copyTo(target);
        return this;
    }

    public ArrayAdapter<E> rotate(int distance) {
        super.rotate(distance);
        return this;
    }

    public ArrayAdapter<E> replaceAll(E oldVal, E newVal) {
        super.replaceAll(oldVal, newVal);
        return this;
    }

}
