package jp.sourceforge.glad.collection;

import java.lang.reflect.Array;
import java.util.AbstractList;

/**
 * 
 * @author GLAD!!
 * @param <E> コンポーネントの型
 */
public class FixedList<E> extends AbstractList<E> {

    final Object array;

    public FixedList(Object o) {
        this.array = toArray(o);
    }

    public FixedList(E... array) {
        this.array = array;
    }

    public FixedList(Class<?> componentType, int length) {
        this.array = Array.newInstance(componentType, length);
    }

    static Object toArray(Object o) {
        Class<?> clazz = o.getClass();
        if (clazz.isArray()) {
            return o;
        }
        Object array = Array.newInstance(clazz, 1);
        Array.set(array, 0, o);
        return array;
    }

    @SuppressWarnings("unchecked")
    public <A> A array() {
        return (A) array;
    }

    public int length() {
        return Array.getLength(array);
    }

    public int size() {
        return length();
    }

    @SuppressWarnings("unchecked")
    public E get(int index) {
        return (E) Array.get(array, index);
    }

    public boolean getBoolean(int index) {
        return Array.getBoolean(array, index);
    }

    public char getChar(int index) {
        return Array.getChar(array, index);
    }

    public byte getByte(int index) {
        return Array.getByte(array, index);
    }

    public short getShort(int index) {
        return Array.getShort(array, index);
    }

    public int getInt(int index) {
        return Array.getInt(array, index);
    }

    public long getLong(int index) {
        return Array.getLong(array, index);
    }

    public float getFloat(int index) {
        return Array.getFloat(array, index);
    }

    public double getDouble(int index) {
        return Array.getDouble(array, index);
    }

    public E set(int index, E value) {
        E oldValue = get(index);
        Array.set(array, index, value);
        return oldValue;
    }

    public boolean setBoolean(int index, boolean value) {
        boolean oldValue = getBoolean(index);
        Array.setBoolean(array, index, value);
        return oldValue;
    }

    public char setChar(int index, char value) {
        char oldValue = getChar(index);
        Array.setChar(array, index, value);
        return oldValue;
    }

    public byte setByte(int index, byte value) {
        byte oldValue = getByte(index);
        Array.setByte(array, index, value);
        return oldValue;
    }

    public short setShort(int index, short value) {
        short oldValue = getShort(index);
        Array.setShort(array, index, value);
        return oldValue;
    }

    public int setInt(int index, int value) {
        int oldValue = getInt(index);
        Array.setInt(array, index, value);
        return oldValue;
    }

    public long setLong(int index, long value) {
        long oldValue = getLong(index);
        Array.setLong(array, index, value);
        return oldValue;
    }

    public float setFloat(int index, float value) {
        float oldValue = getFloat(index);
        Array.setFloat(array, index, value);
        return oldValue;
    }

    public double setDouble(int index, double value) {
        double oldValue = getDouble(index);
        Array.setDouble(array, index, value);
        return oldValue;
    }

}
