package jp.sourceforge.glad.io;

import java.io.IOException;

public class IORuntimeException extends RuntimeException {

    private static final long serialVersionUID = -8961685814009213749L;

    public IORuntimeException() {
    }

    public IORuntimeException(String message) {
        super(message);
    }

    public IORuntimeException(Throwable cause) {
        super(cause);
    }

    public IORuntimeException(String message, Throwable cause) {
        super(message, cause);
    }

    public IORuntimeException(IOException e) {
        this(e.getMessage(), e);
    }

    public IOException getIOException() {
        Throwable cause = getCause();
        if (IOException.class.isInstance(cause)) {
            return IOException.class.cast(cause);
        } else {
            return new IOException(getMessage());
        }
    }

}
