package jp.sourceforge.glad.math.internal;

import java.math.BigDecimal;
import java.math.BigInteger;

class NullState implements NumberState {

    static NullState getInstance() {
        return instance;
    }

    public BigInteger toBigInteger(NumberContext context) {
        return BigInteger.ZERO;
    }

    public BigDecimal toBigDecimal(NumberContext context) {
        return BigDecimal.ZERO;
    }

    public void add(NumberContext context, int value) {
        IntState.getInstance().init(context, value);
    }

    public void add(NumberContext context, long value) {
        LongState.getInstance().init(context, value);
    }

    public void add(NumberContext context, BigInteger value) {
        BigIntegerState.getInstance().init(context, value);
    }

    public void add(NumberContext context, BigDecimal value) {
        BigDecimalState.getInstance().init(context, value);
    }

    public void subtract(NumberContext context, int value) {
        IntState.getInstance().init(context, -value);
    }

    public void subtract(NumberContext context, long value) {
        LongState.getInstance().init(context, -value);
    }

    public void subtract(NumberContext context, BigInteger value) {
        BigIntegerState.getInstance().init(context, value.negate());
    }

    public void subtract(NumberContext context, BigDecimal value) {
        BigDecimalState.getInstance().init(context, value.negate());
    }

    public void multiply(NumberContext context, int value) {
        IntState.getInstance().init(context, 0);
    }

    public void multiply(NumberContext context, long value) {
        LongState.getInstance().init(context, 0L);
    }

    public void multiply(NumberContext context, BigInteger value) {
        BigIntegerState.getInstance().init(context, BigInteger.ZERO);
    }

    public void multiply(NumberContext context, BigDecimal value) {
        BigDecimalState.getInstance().init(context, BigDecimal.ZERO);
    }

    public void divide(NumberContext context, int value) {
        IntState.getInstance().divide(context, value);
    }

    public void divide(NumberContext context, long value) {
        LongState.getInstance().divide(context, value);
    }

    public void divide(NumberContext context, BigInteger value) {
        BigIntegerState.getInstance().divide(context, value);
    }

    public void divide(NumberContext context, BigDecimal value) {
        BigDecimalState.getInstance().divide(context, value);
    }

    public void divideToIntegralValue(
            NumberContext context, BigDecimal value) {
        BigDecimalState.getInstance().divideToIntegralValue(context, value);
    }

    public void remainder(NumberContext context, int value) {
        IntState.getInstance().remainder(context, value);
    }

    public void remainder(NumberContext context, long value) {
        LongState.getInstance().remainder(context, value);
    }

    public void remainder(NumberContext context, BigInteger value) {
        BigIntegerState.getInstance().remainder(context, value);
    }

    public void remainder(NumberContext context, BigDecimal value) {
        BigDecimalState.getInstance().remainder(context, value);
    }

    // ---- toString

    public String toString(NumberContext context) {
        return "0";
    }

    static final NullState instance = new NullState();

}
