package jp.sourceforge.glad.math.internal;

import java.math.BigDecimal;
import java.math.BigInteger;

public interface NumberState {

    BigInteger toBigInteger(NumberContext context);

    BigDecimal toBigDecimal(NumberContext context);

    // ---- add

    void add(NumberContext context, int value);

    void add(NumberContext context, long value);

    void add(NumberContext context, BigInteger value);

    void add(NumberContext context, BigDecimal value);

    // ---- subtract

    void subtract(NumberContext context, int value);

    void subtract(NumberContext context, long value);

    void subtract(NumberContext context, BigInteger value);

    void subtract(NumberContext context, BigDecimal value);

    // ---- multiply

    void multiply(NumberContext context, int value);

    void multiply(NumberContext context, long value);

    void multiply(NumberContext context, BigInteger value);

    void multiply(NumberContext context, BigDecimal value);

    // ---- divide

    void divide(NumberContext context, int value);

    void divide(NumberContext context, long value);

    void divide(NumberContext context, BigInteger value);

    void divide(NumberContext context, BigDecimal value);

    // ---- divideToIntegralValue

    void divideToIntegralValue(NumberContext context, BigDecimal value);

    // ---- remainder

    void remainder(NumberContext context, int value);

    void remainder(NumberContext context, long value);

    void remainder(NumberContext context, BigInteger value);

    void remainder(NumberContext context, BigDecimal value);

    // ---- toString

    String toString(NumberContext context);

}
