package jp.sourceforge.glad.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

public class MethodAdapter<T> {

    final Method method;

    public MethodAdapter(Class<?> clazz, String name, Class<?>... paramTypes) {
        this(ReflectionUtils.getDeclaredMethod(clazz, name, paramTypes));
    }

    public MethodAdapter(Method method) {
        this.method = method;
    }

    public Class<?> getDeclaringClass() {
        return method.getDeclaringClass();
    }

    public String getName() {
        return method.getName();
    }

    public int getModifiers() {
        return method.getModifiers();
    }

    public T invoke(Object target, Object... args) {
        ReflectionUtils.makeAccessible(method);
        return ReflectionUtils.<T>invoke(method, target, args);
    }

    public boolean isAccessible() {
        return method.isAccessible();
    }

    public void setAccessible(boolean accessible) {
        method.setAccessible(accessible);
    }

    public void makeAccessible() {
        ReflectionUtils.makeAccessible(method);
    }

    public Annotation[] getAnnotations() {
        return method.getAnnotations();
    }

    public Annotation[] getDeclaredAnnotations() {
        return method.getDeclaredAnnotations();
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        return method.getAnnotation(annotationClass);
    }

    public boolean isAnnotationPresent(
            Class<? extends Annotation> annotationClass) {
        return method.isAnnotationPresent(annotationClass);
    }

    public String toString() {
        return ReflectionUtils.toString(method);
    }

    public String toGenericString() {
        return method.toGenericString();
    }

}
