package jp.sourceforge.glad.reflect;

public class NoSuchMethodRuntimeException extends ReflectionRuntimeException {

    private static final long serialVersionUID = 1242306326186140871L;

    public NoSuchMethodRuntimeException() {
    }

    public NoSuchMethodRuntimeException(String message) {
        super(message);
    }

    public NoSuchMethodRuntimeException(Throwable cause) {
        super(cause);
    }

    public NoSuchMethodRuntimeException(String message, Throwable cause) {
        super(message, cause);
    }

    public NoSuchMethodRuntimeException(NoSuchMethodException e) {
        this(e.getMessage(), e);
    }

    public NoSuchMethodException getNoSuchMethodException() {
        Throwable cause = getCause();
        if (NoSuchMethodException.class.isInstance(cause)) {
            return NoSuchMethodException.class.cast(cause);
        } else {
            return new NoSuchMethodException(getMessage());
        }
    }

}
