/*
 * Copyright (C) 2008-2009 GLAD!! (ITO Yoshiichi)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sourceforge.glad.struts.config;

import java.lang.reflect.Method;

import org.apache.struts.config.ActionConfig;
import org.apache.struts.config.FormBeanConfig;
import org.apache.struts.config.ModuleConfig;

/**
 * Action、ActionForm に記述したアノテーションから ModuleConfig を作成するクラス。
 * 
 * @author GLAD!!
 */
public interface ModuleConfigBuilder {

    ModuleConfig getModuleConfig();

    void setModuleConfig(ModuleConfig moduleConfig);

    // ---- FormBeanConfig

    void addFormBeanConfig(Class<?> formClass);

    FormBeanConfig createFormBeanConfig(Class<?> formClass);

    // ---- ActionConfig

    void addActionConfigs(Class<?> actionClass);

    void addActionConfig(Class<?> actionClass);

    void addActionConfig(Class<?> actionClass, Method method);

    ActionConfig createActionConfig(Class<?> actionClass);

    ActionConfig createActionConfig(Class<?> actionClass, Method method);

}
