package jp.sourceforge.glad.calendar.holiday;

import java.util.Locale;

import junit.framework.TestCase;

/**
 * {@link AutumnalEquinoxDay} の単体テスト。
 * 
 * @author GLAD!!
 * @see http://www.nao.ac.jp/QA/faq/a0301.html
 * @see http://www.asahi-net.or.jp/~CI5M-NMR/misc/equinox.html
 */
public class AutumnalEquinoxDayTest extends TestCase {

    AutumnalEquinoxDay holiday;

    protected void setUp() throws Exception {
        holiday = new AutumnalEquinoxDay("JP", "Shubun-no-hi", 1948, null);
    }

    protected void tearDown() throws Exception {
        holiday = null;
    }

    public void testBasic() {
        assertEquals("JP", holiday.getCountry());
        assertEquals("Shubun-no-hi", holiday.getRawName());
        assertEquals("秋分の日", holiday.getName());
        assertEquals("秋分の日", holiday.getName(Locale.JAPAN));
        assertEquals("Autumnal Equinox Day", holiday.getName(Locale.US));
        assertEquals(9, holiday.getMonth());
        assertEquals(0, holiday.getDayOfMonth());
        assertEquals(0, holiday.getWeekOfMonth());
        assertEquals(0, holiday.getDayOfWeek());
        assertEquals((Integer) 1948, holiday.getStartYear());
        assertNull(holiday.getEndYear());
        assertFalse(holiday.isAvailableYear(1947));
        assertTrue (holiday.isAvailableYear(1948));
        assertTrue (holiday.isAvailableYear(2008));
        assertEquals("Shubun-no-hi: 09-??", holiday.toString());
    }

    // 2000年以前の日付は、官報の「暦要項」からの引用を参照。
    // http://www.asahi-net.or.jp/~CI5M-NMR/misc/equinox.html

    public void test19950s() {
        checkDate_equals("1950-09-23", 1950);
        checkDate_equals("1951-09-24", 1951);
        checkDate_equals("1952-09-23", 1952);
        checkDate_equals("1953-09-23", 1953);
        checkDate_equals("1954-09-23", 1954);
        checkDate_equals("1955-09-24", 1955);
        checkDate_equals("1956-09-23", 1956);
        checkDate_equals("1957-09-23", 1957);
        checkDate_equals("1958-09-23", 1958);
        checkDate_equals("1959-09-24", 1959);
    }

    public void test1960s() {
        checkDate_equals("1960-09-23", 1960);
        checkDate_equals("1961-09-23", 1961);
        checkDate_equals("1962-09-23", 1962);
        checkDate_equals("1963-09-24", 1963);
        checkDate_equals("1964-09-23", 1964);
        checkDate_equals("1965-09-23", 1965);
        checkDate_equals("1966-09-23", 1966);
        checkDate_equals("1967-09-24", 1967);
        checkDate_equals("1968-09-23", 1968);
        checkDate_equals("1969-09-23", 1969);
    }

    public void test1970s() {
        checkDate_equals("1970-09-23", 1970);
        checkDate_equals("1971-09-24", 1971);
        checkDate_equals("1972-09-23", 1972);
        checkDate_equals("1973-09-23", 1973);
        checkDate_equals("1974-09-23", 1974);
        checkDate_equals("1975-09-24", 1975);
        checkDate_equals("1976-09-23", 1976);
        checkDate_equals("1977-09-23", 1977);
        checkDate_equals("1978-09-23", 1978);
        checkDate_equals("1979-09-24", 1979);
    }

    public void test1980s() {
        checkDate_equals("1980-09-23", 1980);
        checkDate_equals("1981-09-23", 1981);
        checkDate_equals("1982-09-23", 1982);
        checkDate_equals("1983-09-23", 1983);
        checkDate_equals("1984-09-23", 1984);
        checkDate_equals("1985-09-23", 1985);
        checkDate_equals("1986-09-23", 1986);
        checkDate_equals("1987-09-23", 1987);
        checkDate_equals("1988-09-23", 1988);
        checkDate_equals("1989-09-23", 1989);
    }

    public void test1990s() {
        checkDate_equals("1990-09-23", 1990);
        checkDate_equals("1991-09-23", 1991);
        checkDate_equals("1992-09-23", 1992);
        checkDate_equals("1993-09-23", 1993);
        checkDate_equals("1994-09-23", 1994);
        checkDate_equals("1995-09-23", 1995);
        checkDate_equals("1996-09-23", 1996);
        checkDate_equals("1997-09-23", 1997);
        checkDate_equals("1998-09-23", 1998);
        checkDate_equals("1999-09-23", 1999);
    }

    // 2000 年以降の日付は、「国立天文台」のサイトを参照。
    // http://www.nao.ac.jp/QA/faq/a0301.html

    public void test2000s() {
        checkDate_equals("2000-09-23", 2000);
        checkDate_equals("2001-09-23", 2001);
        checkDate_equals("2002-09-23", 2002);
        checkDate_equals("2003-09-23", 2003);
        checkDate_equals("2004-09-23", 2004);
        checkDate_equals("2005-09-23", 2005);
        checkDate_equals("2006-09-23", 2006);
        checkDate_equals("2007-09-23", 2007);
        checkDate_equals("2008-09-23", 2008);
        checkDate_equals("2009-09-23", 2009);
    }

    public void test2010s() {
        checkDate_equals("2010-09-23", 2010);
        checkDate_equals("2011-09-23", 2011);
        checkDate_equals("2012-09-22", 2012);
        checkDate_equals("2013-09-23", 2013);
        checkDate_equals("2014-09-23", 2014);
        checkDate_equals("2015-09-23", 2015);
        checkDate_equals("2016-09-22", 2016);
        checkDate_equals("2017-09-23", 2017);
        checkDate_equals("2018-09-23", 2018);
        checkDate_equals("2019-09-23", 2019);
    }

    public void test2020s() {
        checkDate_equals("2020-09-22", 2020);
        checkDate_equals("2021-09-23", 2021);
        checkDate_equals("2022-09-23", 2022);
        checkDate_equals("2023-09-23", 2023);
        checkDate_equals("2024-09-22", 2024);
        checkDate_equals("2025-09-23", 2025);
        checkDate_equals("2026-09-23", 2026);
        checkDate_equals("2027-09-23", 2027);
        checkDate_equals("2028-09-22", 2028);
        checkDate_equals("2029-09-23", 2029);
    }

    public void test2030s() {
        checkDate_equals("2030-09-23", 2030);
    }

    void checkDate_equals(String expected, int year) {
        assertEquals(expected, holiday.getISOCalendar(year).formatDate());
    }

}
