package jp.sourceforge.glad.collection;

import jp.sourceforge.glad.collection.FixedList;
import junit.framework.TestCase;

/**
 * {@link FixedList} の単体テスト。
 * 
 * @author GLAD!!
 */
public class ArrayAdapterTest extends TestCase {

    public void testBoolean() {
        ArrayAdapter<Boolean> a = new ArrayAdapter<Boolean>(boolean.class, 2)
            .set(0, true)
            .setBoolean(1, false);
        assertEquals(2, a.length());
        assertEquals(true, a.getBoolean(0));
        assertEquals(false, a.get(1).booleanValue());
        assertEquals("[true, false]", a.toString());
        
        boolean[] array = a.array();
        assertEquals(2, array.length);
    }

    public void testChar() {
        ArrayAdapter<Character> a = new ArrayAdapter<Character>(char.class, 3)
            .set(0, 'a')
            .setChar(1, 'b')
            .setChar(2, 'c');
        assertEquals(3, a.length());
        assertEquals('a', a.getChar(0));
        assertEquals('b', a.get(1).charValue());
        assertEquals(Character.valueOf('c'), a.get(2));
        assertEquals("[a, b, c]", a.toString());
        
        char[] array = a.array();
        assertEquals(3, array.length);
    }

    public void testByte() {
        ArrayAdapter<Byte> a = new ArrayAdapter<Byte>(byte.class, 3)
            .set(0, (byte) 1)
            .setByte(1, (byte) 2)
            .setByte(2, (byte) 3);
        assertEquals(3, a.length());
        assertEquals(1, a.getByte(0));
        assertEquals(2, a.get(1).byteValue());
        assertEquals(Byte.valueOf((byte) 3), a.get(2));
        assertEquals("[1, 2, 3]", a.toString());
        
        byte[] array = a.array();
        assertEquals(3, array.length);
    }

    public void testShort() {
        ArrayAdapter<Short> a = new ArrayAdapter<Short>(short.class, 3)
            .set(0, (short) 1)
            .setShort(1, (short) 2)
            .setShort(2, (short) 3);
        assertEquals(3, a.length());
        assertEquals(1, a.getShort(0));
        assertEquals(2, a.get(1).shortValue());
        assertEquals(Short.valueOf((short) 3), a.get(2));
        assertEquals("[1, 2, 3]", a.toString());
        
        short[] array = a.array();
        assertEquals(3, array.length);
    }

    public void testInt() {
        ArrayAdapter<Integer> a = new ArrayAdapter<Integer>(int.class, 3)
            .set(0, 1)
            .setInt(1, 2)
            .setInt(2, 3);
        assertEquals(3, a.length());
        assertEquals(1, a.getInt(0));
        assertEquals(2, a.get(1).intValue());
        assertEquals(Integer.valueOf(3), a.get(2));
        assertEquals("[1, 2, 3]", a.toString());
        
        int[] array = a.array();
        assertEquals(3, array.length);
    }

    public void testLong() {
        ArrayAdapter<Long> a = new ArrayAdapter<Long>(long.class, 3)
            .set(0, 1L)
            .setLong(1, 2L)
            .setLong(2, 3);
        assertEquals(3, a.length());
        assertEquals(1, a.getLong(0));
        assertEquals(2L, a.get(1).longValue());
        assertEquals(Long.valueOf(3), a.get(2));
        assertEquals("[1, 2, 3]", a.toString());
        
        long[] array = a.array();
        assertEquals(3, array.length);
    }

    public void testFloat() {
        ArrayAdapter<Float> a = new ArrayAdapter<Float>(float.class, 3)
            .set(0, 1F)
            .setFloat(1, 2F)
            .setFloat(2, 3);
        assertEquals(3, a.length());
        assertEquals(1, a.getFloat(0), 0);
        assertEquals(2F, a.get(1).floatValue(), 0);
        assertEquals(Float.valueOf(3), a.get(2));
        assertEquals("[1.0, 2.0, 3.0]", a.toString());
        
        float[] array = a.array();
        assertEquals(3, array.length);
    }

    public void testDouble() {
        ArrayAdapter<Double> a = new ArrayAdapter<Double>(double.class, 3)
            .set(0, 1.0)
            .setDouble(1, 2.0)
            .setDouble(2, 3);
        assertEquals(3, a.length());
        assertEquals(1, a.getDouble(0), 0);
        assertEquals(2.0, a.get(1).doubleValue(), 0);
        assertEquals(Double.valueOf(3), a.get(2));
        assertEquals("[1.0, 2.0, 3.0]", a.toString());
        
        double[] array = a.array();
        assertEquals(3, array.length);
    }

    public void testString() {
        ArrayAdapter<String> a = new ArrayAdapter<String>("a", "b", "c");
        assertEquals(3, a.length());
        assertEquals("a", a.get(0));
        assertEquals("b", a.get(1));
        assertEquals("c", a.get(2));
        assertEquals("[a, b, c]", a.toString());
        
        String[] array = a.array();
        assertEquals(3, array.length);
        
        a = new ArrayAdapter<String>("a");
        assertEquals(1, a.length());
        assertEquals("a", a.get(0));
        assertEquals("[a]", a.toString());
        
        a = new ArrayAdapter<String>(new String[] {"a", "b", "c"});
        assertEquals(3, a.length());
        assertEquals("a", a.get(0));
        assertEquals("b", a.get(1));
        assertEquals("c", a.get(2));
        assertEquals("[a, b, c]", a.toString());
        
        a = new ArrayAdapter<String>(String.class, 1);
        assertNull(a.get(0));
        try {
            a.get(1);
            fail();
        } catch (ArrayIndexOutOfBoundsException e) {
        }
        try {
            a.set(1, "b");
        } catch (ArrayIndexOutOfBoundsException e) {
        }
        
        a = new ArrayAdapter<String>(String.class, 3)
            .set(0, "a")
            .set(1, "b")
            .set(2, "c");
        assertEquals(3, a.length());
        assertEquals("a", a.get(0));
        assertEquals("b", a.get(1));
        assertEquals("c", a.get(2));
        assertEquals("[a, b, c]", a.toString());
    }

}
