package jp.sourceforge.glad.collection;

import junit.framework.TestCase;

public class MapAdapterTest extends TestCase {

    public void testPut() {
        MapAdapter<Integer, String> map = new MapAdapter<Integer, String>()
            .put(1, "a")
            .put(4, "b")
            .put(3, "c")
            .put(2, "d")
            .put(4, "e");
        assertAdapterEquals("{1=a, 4=e, 3=c, 2=d}", map);
        assertSame(map, map.put(6, "f").put(5, "g"));
        assertAdapterEquals("{1=a, 4=e, 3=c, 2=d, 6=f, 5=g}", map);
    }

    static void assertAdapterEquals(String expected, MapAdapter<?, ?> actual) {
        assertEquals(expected, actual.toString());
    }

}
