package jp.sourceforge.glad.jdbc.h2;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;

import junit.framework.TestCase;

public class H2DatabaseTest extends TestCase {

    H2Database database;
    
    protected void setUp() throws Exception {
        database = new H2Database();
    }

    protected void tearDown() throws Exception {
        database = null;
    }

    public void testGetConnection() throws Exception {
        Connection connection = database.getConnection();
        try {
            assertNotNull(connection);
            Statement stmt = connection.createStatement();
            try {
                ResultSet rs = stmt.executeQuery("CALL CURRENT_TIMESTAMP");
                try {
                    assertTrue(rs.next());
                    Timestamp timestamp = rs.getTimestamp(1);
                    System.out.println(timestamp);
                    assertNotNull(timestamp);
                } finally {
                    rs.close();
                }
            } finally {
                stmt.close();
            }
        } finally {
            connection.close();
        }
    }

}
