package jp.sourceforge.glad.util;

import junit.framework.TestCase;

/**
 * {@link JapaneseUtils} の単体テスト。
 * 
 * @author GLAD!!
 */
public class JapaneseUtilsTest extends TestCase {

    static final String JIS_X_0221_TEXT
            = "\u301C\u2016\u2212\u00A2\u00A3\u00AC";
    static final String WINDOWS_31J_TEXT
            = "\uFF5E\u2225\uFF0D\uFFE0\uFFE1\uFFE2";
    static final String ORACLE_JA16_TEXT
            = "\u301C\u2225\uFF0D\uFFE0\uFFE1\uFFE2";
    
    public void testToJISX0221CS() {
        assertEquals(JIS_X_0221_TEXT,
                JapaneseUtils.toJISX0221CS(JIS_X_0221_TEXT));
        assertEquals(JIS_X_0221_TEXT,
                JapaneseUtils.toJISX0221CS(WINDOWS_31J_TEXT));
        assertEquals(JIS_X_0221_TEXT,
                JapaneseUtils.toJISX0221CS(ORACLE_JA16_TEXT));
    }

    public void testToWindows31JCS() {
        assertEquals(WINDOWS_31J_TEXT,
                JapaneseUtils.toWindows31JCS(JIS_X_0221_TEXT));
        assertEquals(WINDOWS_31J_TEXT,
                JapaneseUtils.toWindows31JCS(WINDOWS_31J_TEXT));
        assertEquals(WINDOWS_31J_TEXT,
                JapaneseUtils.toWindows31JCS(ORACLE_JA16_TEXT));
    }

    public void testToOracleJA16CS() {
        assertEquals(ORACLE_JA16_TEXT,
                JapaneseUtils.toOracleJA16CS(JIS_X_0221_TEXT));
        assertEquals(ORACLE_JA16_TEXT,
                JapaneseUtils.toOracleJA16CS(WINDOWS_31J_TEXT));
        assertEquals(ORACLE_JA16_TEXT,
                JapaneseUtils.toOracleJA16CS(ORACLE_JA16_TEXT));
    }

}
