package jp.sourceforge.glad.util;

import junit.framework.TestCase;

/**
 * {@link StringUtils} の単体テスト。
 * 
 * @author GLAD!!
 */
public class StringUtilsTest extends TestCase {

    public void testIsEmpty() {
        assertTrue(StringUtils.isEmpty(null));
        assertTrue(StringUtils.isEmpty(""));
        assertFalse(StringUtils.isEmpty(" "));
        assertFalse(StringUtils.isEmpty("foo"));
    }

    public void testIsNotEmpty() {
        assertFalse(StringUtils.isNotEmpty(null));
        assertFalse(StringUtils.isNotEmpty(""));
        assertTrue(StringUtils.isNotEmpty(" "));
        assertTrue(StringUtils.isNotEmpty("foo"));
    }

    public void testSplitWords() {
        assertNull(StringUtils.splitWords(null));
        assertEquals(0, StringUtils.splitWords("").length);
        String[] words =
                StringUtils.splitWords("_fo1oBA2RBa3z_fo4o_BA5R_Ba6z__");
        assertEquals(6, words.length);
        assertEquals("fo1o", words[0]);
        assertEquals("BA2R", words[1]);
        assertEquals("Ba3z", words[2]);
        assertEquals("fo4o", words[3]);
        assertEquals("BA5R", words[4]);
        assertEquals("Ba6z", words[5]);
    }

    public void testCapitalize() {
        assertNull(StringUtils.capitalize(null));
        assertEquals("", StringUtils.capitalize(""));
        assertEquals("FooBar", StringUtils.capitalize("fooBar"));
        assertEquals("FooBAR", StringUtils.capitalize("fooBAR"));
        assertEquals("FooBar", StringUtils.capitalize("FooBar"));
        assertEquals("FooBAR", StringUtils.capitalize("FooBAR"));
        assertEquals("FOOBar", StringUtils.capitalize("FOOBar"));
    }

    public void testUncapitalize() {
        assertNull(StringUtils.uncapitalize(null));
        assertEquals("", StringUtils.uncapitalize(""));
        assertEquals("fooBar", StringUtils.uncapitalize("fooBar"));
        assertEquals("fooBAR", StringUtils.uncapitalize("fooBAR"));
        assertEquals("fooBar", StringUtils.uncapitalize("FooBar"));
        assertEquals("fooBAR", StringUtils.uncapitalize("FooBAR"));
        assertEquals("fooBar", StringUtils.uncapitalize("FOOBar"));
    }

    public void testToPascalCase() {
        assertNull(StringUtils.toPascalCase(null));
        assertEquals("", StringUtils.toPascalCase(""));
        assertEquals("FooBar", StringUtils.toPascalCase("fooBar"));
        assertEquals("FooBar", StringUtils.toPascalCase("fooBAR"));
        assertEquals("FooBar", StringUtils.toPascalCase("FooBar"));
        assertEquals("FooBar", StringUtils.toPascalCase("FooBAR"));
        assertEquals("FooBar", StringUtils.toPascalCase("FOOBar"));
        assertEquals("FooBar", StringUtils.toPascalCase("_foo_bar__"));
        assertEquals("FooBar", StringUtils.toPascalCase("_foo_Bar__"));
        assertEquals("FooBar", StringUtils.toPascalCase("_foo_BAR__"));
        assertEquals("FooBar", StringUtils.toPascalCase("_Foo_bar__"));
        assertEquals("FooBar", StringUtils.toPascalCase("_Foo_Bar__"));
        assertEquals("FooBar", StringUtils.toPascalCase("_Foo_BAR__"));
        assertEquals("FooBar", StringUtils.toPascalCase("_FOO_bar__"));
        assertEquals("FooBar", StringUtils.toPascalCase("_FOO_Bar__"));
        assertEquals("FooBar", StringUtils.toPascalCase("_FOO_BAR__"));
    }

    public void testToCamelCase() {
        assertNull(StringUtils.toCamelCase(null));
        assertEquals("", StringUtils.toCamelCase(""));
        assertEquals("fooBar", StringUtils.toCamelCase("fooBar"));
        assertEquals("fooBar", StringUtils.toCamelCase("fooBAR"));
        assertEquals("fooBar", StringUtils.toCamelCase("FooBar"));
        assertEquals("fooBar", StringUtils.toCamelCase("FooBAR"));
        assertEquals("fooBar", StringUtils.toCamelCase("FOOBar"));
        assertEquals("fooBar", StringUtils.toCamelCase("_foo_bar__"));
        assertEquals("fooBar", StringUtils.toCamelCase("_foo_Bar__"));
        assertEquals("fooBar", StringUtils.toCamelCase("_foo_BAR__"));
        assertEquals("fooBar", StringUtils.toCamelCase("_Foo_bar__"));
        assertEquals("fooBar", StringUtils.toCamelCase("_Foo_Bar__"));
        assertEquals("fooBar", StringUtils.toCamelCase("_Foo_BAR__"));
        assertEquals("fooBar", StringUtils.toCamelCase("_FOO_bar__"));
        assertEquals("fooBar", StringUtils.toCamelCase("_FOO_Bar__"));
        assertEquals("fooBar", StringUtils.toCamelCase("_FOO_BAR__"));
    }

}
