package com.example.echo.client;

import javax.xml.ws.soap.SOAPFaultException;

import junit.framework.TestCase;

import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;

import com.example.echo.Echo;
import com.example.echo.client.cxf2axisWL.EchoAxisWL;
import com.example.echo.client.cxf2cxf.EchoService;

public class EchoCxfClientTest extends TestCase {

    static final String ENDPOINT_BASE =
            "http://localhost:8080/mule-example/services/";

    public void testEchoCxfSA_withJaxWs() throws Exception {
        JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
        factory.setServiceClass(Echo.class);
        factory.setAddress("http://localhost:65083/services/echoCxf");
        Echo client = (Echo) factory.create();
        assertEquals("Hello!", client.echo("Hello!"));
    }

    public void testEchoCxf_withJaxWs() throws Exception {
        JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
        factory.setServiceClass(Echo.class);
        factory.setAddress(ENDPOINT_BASE + "echoCxf");
        Echo client = (Echo) factory.create();
        assertEquals("Hello!", client.echo("Hello!"));
    }

    public void testEchoCxf_withStub() {
        com.example.echo.client.cxf2cxf.Echo port =
                new EchoService().getEchoPort();
        assertEquals("Hello!", port.echo("Hello!"));
    }

    public void testEchoCxf_withStub_checkError() {
        com.example.echo.client.cxf2cxf.Echo port =
                new EchoService().getEchoPort();
        assertEquals("ERROR!!", port.echo("error"));
    }

    public void testEchoCxf_withStub_checkException() {
        com.example.echo.client.cxf2cxf.Echo port =
                new EchoService().getEchoPort();
        try {
            port.echo("exception");
            fail();
        } catch (SOAPFaultException e) {
            e.printStackTrace();
        }
    }

    public void testEchoAxisWL_withStub() {
        com.example.echo.client.cxf2axisWL.Echo port =
                new EchoAxisWL().getEchoAxisWL();
        assertEquals("Hello!", port.echo("Hello!"));
    }

}
