#
# mkAllData.rb
#

require 'fileutils'
require 'LinearGraphTemplate'
require 'OrthogonalArray'

FileUtils.makedirs('data')

[
   4,
   8,
  16
].each {|n|
  template = LinearGraphTemplate.new(n, n.to_s)
  puts template.summary
  open("data/LGT.#{ template.size }.txt", 'w') {|out|
    out.puts template
  }
}

[
  [  8, ''  ],
  [ 16, ''  ],
  [ 32, ''  ],
  [ 64, '4' ],
  [ 64, ''  ],
  [ 64, '16'],
  [128, ''  ],
  [256, '4' ],
  [256, ''  ]
].each {|a|
  template = LinearGraphTemplate.new(a[0], a[1])
  puts template.summary
  suffix = template.levels.join('-').gsub(/\^/, '.')
  open("data/LGT.#{ template.size }-#{ suffix }.txt", 'w') {|out|
    out.puts template
  }
}

[
  [  4, ''  ],
  [  8, '2' ],
  [  8, ''  ],
  [ 16, '2' ],
  [ 16, ''  ],
  [ 16, '8' ],
  [ 32, '2' ],
  [ 32, ''  ],
  [ 64, '2' ],
  [ 64, '4' ],
  [ 64, ''  ],
  [ 64, '16'],
  [128, '2' ],
  [128, ''  ],
  [256, '2' ],
  [256, '4' ],
  [256, ''  ]
].each {|a|
  oa = OrthogonalArray.new(a[0], a[1])
  puts oa.summary
  suffix = oa.template.levels.join('-').gsub(/\^/, '.')
  open("data/OA.#{ oa.size }-#{ suffix }.txt", 'w') {|out|
    oa.print(out)
  }
}
