package jp.sourceforge.glad.org.seasar.dao.tiger;

import java.util.List;

import org.seasar.dao.tiger.FetchHandler;

public interface GenericDao<ENTITY, ID> {

    ENTITY getById(ID id);

    List<ENTITY> findAll();

    int iterateAll(FetchHandler<ENTITY> handler);

    int insert(ENTITY entity);

    int[] insertBatch(List<ENTITY> entities);

    int update(ENTITY entity);

    int[] updateBatch(List<ENTITY> entities);

    int delete(ENTITY entity);

    int[] deleteBatch(List<ENTITY> entities);

}
