/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import javax.jws.WebParam;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.jaxb.JAXBUtils;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.model.Annotator;
import org.apache.cxf.tools.common.model.JAnnotation;
import org.apache.cxf.tools.common.model.JAnnotationElement;
import org.apache.cxf.tools.common.model.JavaInterface;
import org.apache.cxf.tools.common.model.JavaMethod;
import org.apache.cxf.tools.common.model.JavaParameter;
import org.apache.cxf.tools.common.model.JavaReturn;
import org.apache.cxf.tools.common.model.JavaType;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.customization.JAXWSBinding;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.AbstractProcessor;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.FaultProcessor;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.ParameterProcessor;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.ProcessorUtil;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.annotator.WSActionAnnotator;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.annotator.WebMethodAnnotator;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.annotator.WebResultAnnotator;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.annotator.WrapperAnnotator;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.mapper.MethodMapper;

public class OperationProcessor
extends AbstractProcessor {
    private JavaParameter wrapperRequest;
    private JavaParameter wrapperResponse;

    public OperationProcessor(ToolContext c) {
        super(c);
    }

    public void process(JavaInterface intf, OperationInfo operation) throws ToolException {
        JavaMethod method = new MethodMapper().map(operation);
        method.setInterface(intf);
        this.processMethod(method, operation, null);
        Collection faults = operation.getFaults();
        FaultProcessor faultProcessor = new FaultProcessor(this.context);
        faultProcessor.process(method, faults);
        method.annotate((Annotator)new WSActionAnnotator(operation));
        intf.addMethod(method);
    }

    void processMethod(JavaMethod method, OperationInfo operation, JAXWSBinding globalBinding) throws ToolException {
        if (this.isAsyncMethod(method)) {
            return;
        }
        MessageInfo inputMessage = operation.getInput();
        MessageInfo outputMessage = operation.getOutput();
        if (inputMessage == null) {
            LOG.log(Level.WARNING, "NO_INPUT_MESSAGE", new Object[]{operation.getName()});
            Message msg = new Message("INVALID_MEP", LOG, new Object[]{operation.getName()});
            throw new ToolException(msg);
        }
        ParameterProcessor paramProcessor = new ParameterProcessor(this.context);
        method.clear();
        paramProcessor.process(method, inputMessage, outputMessage, operation.getParameterOrdering());
        method.annotate((Annotator)new WebMethodAnnotator());
        if (method.isWrapperStyle()) {
            this.setWrapper(operation);
            method.annotate((Annotator)new WrapperAnnotator(this.wrapperRequest, this.wrapperResponse));
        }
        method.annotate((Annotator)new WebResultAnnotator());
        JAXWSBinding opBinding = (JAXWSBinding)operation.getExtensor(JAXWSBinding.class);
        boolean enableAsync = false;
        if (globalBinding != null && globalBinding.isEnableAsyncMapping() || opBinding != null && opBinding.isEnableAsyncMapping()) {
            enableAsync = true;
        }
        if (!method.isOneWay() && enableAsync && !this.isAddedAsyMethod(method)) {
            this.addAsyncMethod(method);
        }
        if (globalBinding != null && globalBinding.isEnableMime() || opBinding != null && opBinding.isEnableMime()) {
            method.setMimeEnable(true);
        }
    }

    private void setWrapper(OperationInfo operation) {
        MessagePartInfo inputPart = null;
        if (operation.getInput() != null && operation.getInput().getMessageParts() != null) {
            inputPart = (MessagePartInfo)operation.getInput().getMessageParts().iterator().next();
        }
        MessagePartInfo outputPart = null;
        if (operation.getOutput() != null && operation.getOutput().getMessageParts() != null) {
            outputPart = (MessagePartInfo)operation.getOutput().getMessageParts().iterator().next();
        }
        if (inputPart != null) {
            this.wrapperRequest = new JavaParameter();
            this.wrapperRequest.setName(ProcessorUtil.resolvePartName(inputPart));
            this.wrapperRequest.setType(ProcessorUtil.getPartType(inputPart));
            this.wrapperRequest.setTargetNamespace(ProcessorUtil.resolvePartNamespace(inputPart));
            this.wrapperRequest.setClassName(ProcessorUtil.getFullClzName(inputPart, this.context, false));
        }
        if (outputPart != null) {
            this.wrapperResponse = new JavaParameter();
            this.wrapperResponse.setName(ProcessorUtil.resolvePartName(outputPart));
            this.wrapperResponse.setType(ProcessorUtil.getPartType(outputPart));
            this.wrapperResponse.setTargetNamespace(ProcessorUtil.resolvePartNamespace(outputPart));
            this.wrapperResponse.setClassName(ProcessorUtil.getFullClzName(outputPart, this.context, false));
        }
    }

    private boolean isAsyncMethod(JavaMethod method) {
        return method.getName().toLowerCase().equals((method.getOperationName() + "Async").toLowerCase());
    }

    private void addAsyncMethod(JavaMethod method) throws ToolException {
        this.addPollingMethod(method);
        this.addCallbackMethod(method);
        method.getInterface().addImport("javax.xml.ws.AsyncHandler");
        method.getInterface().addImport("java.util.concurrent.Future");
        method.getInterface().addImport("javax.xml.ws.Response");
    }

    private void addCallbackMethod(JavaMethod method) throws ToolException {
        JavaMethod callbackMethod = new JavaMethod(method.getInterface());
        callbackMethod.setAsync(true);
        callbackMethod.setName(method.getName() + "Async");
        callbackMethod.setStyle(method.getStyle());
        callbackMethod.setWrapperStyle(method.isWrapperStyle());
        callbackMethod.setSoapAction(method.getSoapAction());
        callbackMethod.setOperationName(method.getOperationName());
        JavaReturn future = new JavaReturn();
        future.setClassName("Future<?>");
        callbackMethod.setReturn(future);
        callbackMethod.annotate((Annotator)new WebMethodAnnotator());
        callbackMethod.addAnnotation("ResponseWrapper", (JAnnotation)method.getAnnotationMap().get("ResponseWrapper"));
        callbackMethod.addAnnotation("RequestWrapper", (JAnnotation)method.getAnnotationMap().get("RequestWrapper"));
        callbackMethod.addAnnotation("SOAPBinding", (JAnnotation)method.getAnnotationMap().get("SOAPBinding"));
        Iterator iter = method.getParameters().iterator();
        while (iter.hasNext()) {
            callbackMethod.addParameter((JavaParameter)iter.next());
        }
        JavaParameter asyncHandler = new JavaParameter();
        asyncHandler.setName("asyncHandler");
        asyncHandler.setCallback(true);
        asyncHandler.setClassName(this.getAsyncClassName(method, "AsyncHandler"));
        asyncHandler.setStyle(JavaType.Style.IN);
        callbackMethod.addParameter(asyncHandler);
        JAnnotation asyncHandlerAnnotation = new JAnnotation(WebParam.class);
        asyncHandlerAnnotation.addElement(new JAnnotationElement("name", (Object)"asyncHandler"));
        asyncHandlerAnnotation.addElement(new JAnnotationElement("targetNamespace", (Object)""));
        asyncHandler.addAnnotation("WebParam", asyncHandlerAnnotation);
        method.getInterface().addMethod(callbackMethod);
    }

    private void addPollingMethod(JavaMethod method) throws ToolException {
        JavaMethod pollingMethod = new JavaMethod(method.getInterface());
        pollingMethod.setAsync(true);
        pollingMethod.setName(method.getName() + "Async");
        pollingMethod.setStyle(method.getStyle());
        pollingMethod.setWrapperStyle(method.isWrapperStyle());
        pollingMethod.setSoapAction(method.getSoapAction());
        pollingMethod.setOperationName(method.getOperationName());
        JavaReturn response = new JavaReturn();
        response.setClassName(this.getAsyncClassName(method, "Response"));
        pollingMethod.setReturn(response);
        pollingMethod.annotate((Annotator)new WebMethodAnnotator());
        pollingMethod.addAnnotation("RequestWrapper", (JAnnotation)method.getAnnotationMap().get("RequestWrapper"));
        pollingMethod.addAnnotation("ResponseWrapper", (JAnnotation)method.getAnnotationMap().get("ResponseWrapper"));
        pollingMethod.addAnnotation("SOAPBinding", (JAnnotation)method.getAnnotationMap().get("SOAPBinding"));
        Iterator iter = method.getParameters().iterator();
        while (iter.hasNext()) {
            pollingMethod.addParameter((JavaParameter)iter.next());
        }
        method.getInterface().addMethod(pollingMethod);
    }

    private String getAsyncClassName(JavaMethod method, String clzName) {
        String response = this.wrapperResponse != null ? this.wrapperResponse.getClassName() : method.getReturn().getClassName();
        Class mappedClass = JAXBUtils.holderClass((String)response);
        if (mappedClass != null) {
            response = mappedClass.getName();
        }
        StringBuffer sb = new StringBuffer();
        sb.append(clzName);
        sb.append("<");
        sb.append(response);
        sb.append(">");
        return sb.toString();
    }

    private boolean isAddedAsyMethod(JavaMethod method) {
        List jmethods = method.getInterface().getMethods();
        int counter = 0;
        for (JavaMethod jm : jmethods) {
            if (!jm.getOperationName().equals(method.getOperationName())) continue;
            ++counter;
        }
        return counter > 1;
    }
}

