package haskell.prelude.text;

import haskell.lang.Class;
import haskell.prelude.Function;
import haskell.prelude.String;

/**
 * class Show a
 */
public interface Show<A extends Show<A>>
        extends Class<A> {

    String _show_();

    class Support {

        /**
         * show :: a -> String
         */
        public final Function<Show<?>, String> show() {
            return new Function<Show<?>, String>(
                    this, String.class, "show", Show.class);
        }

        /**
         * show x
         */
        public String show(final Show<?> x) {
            return x._show_();
        }

    }

}
