package example.hello.client;

import static example.common.util.ExampleUtils.*;

import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.S2ContainerFactory;

public class S2HelloClient {

    static final String PATH = "example/hello/client/S2HelloClient.dicon";

    public static void main(String[] args) {
        execute(PATH, args);
    }

    public static void execute(String path, String... args) {
        S2Container container = S2ContainerFactory.create(path);
        container.init();
        try {
            HelloClient client = (HelloClient)
                    container.getComponent(HelloClient.class);
            String name = getArg(args, 0);
            System.out.println(client.sayHello(name));
        } finally {
            container.destroy();
        }
    }

}
