package example.hello.client;

import static org.easymock.EasyMock.*;
import junit.framework.TestCase;
import example.hello.dto.HelloRequest;
import example.hello.dto.HelloRequestMatcher;
import example.hello.dto.HelloResponse;
import example.hello.exception.HelloException;
import example.hello.service.HelloService;

public class HelloClientTest extends TestCase {

    HelloClient client;
    HelloService service;

    @Override
    protected void setUp() throws Exception {
        service = createMock(HelloService.class);
        client = new HelloClient(service);
    }

    @Override
    protected void tearDown() throws Exception {
        client = null;
        service = null;
    }

    public void testSayHello() throws HelloException {
        expect(service.sayHello(matchesHelloRequest("John")))
                .andReturn(new HelloResponse("Hello, John!"));
        replay(service);
        
        assertEquals("Hello, John!", client.sayHello("John"));
        verify(service);
    }

    static HelloRequest matchesHelloRequest(final String nameRegex) {
        reportMatcher(new HelloRequestMatcher(nameRegex));
        return null;
    }

}
