package example.hello.exception;

import javax.ejb.ApplicationException;

@ApplicationException(rollback = true)
public class HelloRollbackException extends HelloException {

    private static final long serialVersionUID = -5146243287786726445L;

    public HelloRollbackException() {
    }

    public HelloRollbackException(String message) {
        super(message);
    }

    public HelloRollbackException(Throwable cause) {
        super(cause);
    }

    public HelloRollbackException(String message, Throwable cause) {
        super(message, cause);
    }

    {
        super.setRollbackOnly(true);
    }

    @Override
    public HelloException setRollbackOnly(boolean rollbackOnly) {
        throw new UnsupportedOperationException("setRollbackOnly");
    }

}
