package example.hello.dto;

import java.util.regex.Pattern;

import org.easymock.IArgumentMatcher;

public class HelloRequestMatcher implements IArgumentMatcher {

    private Pattern namePattern;

    public HelloRequestMatcher(String nameRegex) {
        if (nameRegex == null) {
            namePattern = null;
        } else {
            namePattern = Pattern.compile(nameRegex);
        }
    }

    public boolean matches(Object actual) {
        String actualName = ((HelloRequest) actual).getName();
        if (namePattern == null) {
            return (actualName == null);
        } else {
            return namePattern.matcher(actualName).matches();
        }
    }

    public void appendTo(StringBuffer buffer) {
        buffer.append("matchesHelloRequest(");
        if (namePattern == null) {
            buffer.append(namePattern);
        } else {
            buffer.append('/');
            buffer.append(namePattern);
            buffer.append('/');
        }
        buffer.append(')');
    }

}
