package example.hello.action;

import static org.easymock.EasyMock.*;
import example.hello.dto.HelloRequest;
import example.hello.dto.HelloRequestMatcher;
import example.hello.dto.HelloResponse;
import example.hello.exception.HelloException;
import example.hello.service.HelloService;
import junit.framework.TestCase;

public class HelloActionTest extends TestCase {

    HelloAction action;

    @Override
    protected void setUp() throws Exception {
        action = new HelloAction();
        action.service = createMock(HelloService.class);
    }

    @Override
    protected void tearDown() throws Exception {
        action = null;
    }

    public void testIndex() {
        assertEquals("index.html", action.index());
    }

    public void testIndex_jsp() {
        assertEquals("index.jsp", action.index_jsp());
    }

    public void testSayHello() throws HelloException {
        expect(action.service.sayHello(matchesHelloRequest("John")))
                .andReturn(new HelloResponse("Hello, John!"));
        replay(action.service);

        action.name = "John";
        assertEquals("sayHello.html", action.sayHello());
        assertEquals("Hello, John!", action.message);
        verify(action.service);
    }

    public void testSayHello_jsp() throws HelloException {
        expect(action.service.sayHello(matchesHelloRequest("John")))
                .andReturn(new HelloResponse("Hello, John!"));
        replay(action.service);

        action.name = "John";
        assertEquals("sayHello.jsp", action.sayHello_jsp());
        assertEquals("Hello, John!", action.message);
        verify(action.service);
    }

    static HelloRequest matchesHelloRequest(final String nameRegex) {
        reportMatcher(new HelloRequestMatcher(nameRegex));
        return null;
    }

}
