/*
 * Copyright (C) 2008-2009 GLAD!! (ITO Yoshiichi)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sourceforge.glad.calendar.text;

import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;

/**
 * 
 * @author GLAD!!
 */
public class SimpleDateFormat extends java.text.SimpleDateFormat {

    private static final long serialVersionUID = -8203488568241851658L;

    public SimpleDateFormat() {
    }

    public SimpleDateFormat(String pattern) {
        super(pattern);
    }

    public SimpleDateFormat(String pattern, Locale locale) {
        super(pattern, locale);
    }

    public SimpleDateFormat(String pattern, DateFormatSymbols formatSymbols) {
        super(pattern, formatSymbols);
    }

    public String format(Calendar calendar) {
        TimeZone zone = getTimeZone();
        setTimeZone(calendar.getTimeZone());
        try {
            return format(calendar.getTimeInMillis());
        } finally {
            setTimeZone(zone);
        }
    }

}
