package jp.sourceforge.glad.collection.function;

import jp.sourceforge.glad.reflect.MethodAccessor;

public class MethodFunction<S, T> implements Function<S, T> {

    private final MethodAccessor<T> accessor;

    public MethodFunction(Class<?> clazz, String name, Class<?> paramType) {
        this(new MethodAccessor<T>(clazz, name, paramType));
    }

    public MethodFunction(Object target, String name, Class<?> paramType) {
        this(new MethodAccessor<T>(target, name, paramType));
    }

    public MethodFunction(MethodAccessor<T> accessor) {
        this.accessor = accessor;
    }

    public T apply(S source) {
        return accessor.invoke(source);
    }

}
