package jp.sourceforge.glad.collection.predicate;

import jp.sourceforge.glad.collection.closure.Closure;
import jp.sourceforge.glad.collection.exception.BreakException;
import jp.sourceforge.glad.collection.exception.ContinueException;

public class ClosurePredicate<T> implements Predicate<T> {

    private final Closure<T> closure;

    public ClosurePredicate(Closure<T> closure) {
        this.closure = closure;
    }

    public boolean evaludate(T source) throws Exception {
        try {
            closure.execute(source);
            return true;
        } catch (ContinueException e) {
            return true;
        } catch (BreakException e) {
            return false;
        }
    }

}
