package jp.sourceforge.glad.math.internal;

import java.math.BigDecimal;
import java.math.BigInteger;

public class LongState implements NumberState {

    static LongState getInstance() {
        return instance;
    }

    void init(NumberContext context, long value) {
        context.set(value, this);
    }

    public BigInteger toBigInteger(NumberContext context) {
        return BigIntegerState.getInstance()
                .getBigInteger(context.longValue());
    }

    public BigDecimal toBigDecimal(NumberContext context) {
        return BigDecimalState.getInstance()
                .toBigDecimal(context.longValue(), context.getMathContext());
    }

    public void add(NumberContext context, int value) {
        context.set(context.longValue() + value, this);
    }

    public void add(NumberContext context, long value) {
        context.set(context.longValue() + value, this);
    }

    public void add(NumberContext context, BigInteger value) {
        BigIntegerState.getInstance().add(context, value);
    }

    public void add(NumberContext context, BigDecimal value) {
        BigDecimalState.getInstance().add(context, value);
    }

    public void subtract(NumberContext context, int value) {
        context.set(context.longValue() - value, this);
    }

    public void subtract(NumberContext context, long value) {
        context.set(context.longValue() - value, this);
    }

    public void subtract(NumberContext context, BigInteger value) {
        BigIntegerState.getInstance().subtract(context, value);
    }

    public void subtract(NumberContext context, BigDecimal value) {
        BigDecimalState.getInstance().subtract(context, value);
    }

    public void multiply(NumberContext context, int value) {
        context.set(context.longValue() * value, this);
    }

    public void multiply(NumberContext context, long value) {
        context.set(context.longValue() * value, this);
    }

    public void multiply(NumberContext context, BigInteger value) {
        BigIntegerState.getInstance().multiply(context, value);
    }

    public void multiply(NumberContext context, BigDecimal value) {
        BigDecimalState.getInstance().multiply(context, value);
    }

    public void divide(NumberContext context, int value) {
        context.set(context.longValue() / value, this);
    }

    public void divide(NumberContext context, long value) {
        context.set(context.longValue() / value, this);
    }

    public void divide(NumberContext context, BigInteger value) {
        BigIntegerState.getInstance().divide(context, value);
    }

    public void divide(NumberContext context, BigDecimal value) {
        BigDecimalState.getInstance().divide(context, value);
    }

    public void divideToIntegralValue(
            NumberContext context, BigDecimal value) {
        BigDecimalState.getInstance().divideToIntegralValue(context, value);
    }

    public void remainder(NumberContext context, int value) {
        context.set(context.longValue() % value, this);
    }

    public void remainder(NumberContext context, long value) {
        context.set(context.longValue() % value, this);
    }

    public void remainder(NumberContext context, BigInteger value) {
        BigIntegerState.getInstance().remainder(context, value);
    }

    public void remainder(NumberContext context, BigDecimal value) {
        BigDecimalState.getInstance().remainder(context, value);
    }

    // ---- toString

    public String toString(NumberContext context) {
        return String.valueOf(context.longValue());
    }

    static final LongState instance = new LongState();

}
