package jp.sourceforge.glad.reflect;

import java.lang.reflect.InvocationTargetException;

public class InvocationTargetRuntimeException
        extends ReflectionRuntimeException {

    private static final long serialVersionUID = 8352461321360994481L;

    public InvocationTargetRuntimeException() {
    }

    public InvocationTargetRuntimeException(String message) {
        super(message);
    }

    public InvocationTargetRuntimeException(Throwable cause) {
        super(cause);
    }

    public InvocationTargetRuntimeException(String message, Throwable cause) {
        super(message, cause);
    }

    public InvocationTargetRuntimeException(InvocationTargetException e) {
        this(e.getMessage(), e);
    }

    public InvocationTargetException getInvocationTargetException() {
        Throwable cause = getCause();
        if (InvocationTargetException.class.isInstance(cause)) {
            return InvocationTargetException.class.cast(cause);
        } else {
            return new InvocationTargetException(cause, getMessage());
        }
    }

    public Throwable getTargetException() {
        Throwable cause = getCause();
        if (InvocationTargetException.class.isInstance(cause)) {
            return InvocationTargetException.class.cast(cause)
                    .getTargetException();
        } else {
            return cause;
        }
    }

}
