package jp.sourceforge.glad.reflect;

import junit.framework.TestCase;

public class FieldAdapterTest extends TestCase {

    public void testAccess() {
        Example target = new Example("abc");
        FieldAdapter<String> fValue =
                new FieldAdapter<String>(Example.class, "value");
        fValue.makeAccessible();
        assertEquals("abc", fValue.get(target));
        fValue.set(target, "def");
        assertEquals("def", target.getValue());
    }

    public static class Example {
        private String value;
        public Example(String value) {
            this.value = value;
        }
        public String getValue() {
            return value;
        }
    }

}
