package jp.sourceforge.glad.reflect;

import java.util.Arrays;

import junit.framework.TestCase;

public class MethodAccessorTest extends TestCase {

    public void testInvoke() {
        Example target = new Example();
        MethodAccessor<String> doSomething = new MethodAccessor<String>(
                target, "doSomething", int.class, Object[].class);
        assertEquals("Example.doSomething(123, [abc, def])",
                doSomething.invoke(123, "abc", "def"));
    }

    public static class Example {
        public String doSomething(int n, Object... args) {
            return "Example.doSomething("
                    + n + ", " + Arrays.deepToString(args) + ')';
        }
    }

}
