package com.example.bookstore.impl;

import java.util.LinkedHashMap;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.example.bookstore.CustomerService;
import com.example.bookstore.model.Customer;

public class CustomerServiceImpl implements CustomerService {

    static final Log log = LogFactory.getLog(CustomerServiceImpl.class);

    Map<Long, Customer> customerMap = new LinkedHashMap<Long, Customer>();

    long lastCustomerId = 1000;

    public Customer addCustomer(Customer customer) {
        customer.setId(nextCustomerId());
        customerMap.put(customer.getId(), customer);
        if (log.isInfoEnabled()) {
            log.info("Add customer: " + customer);
        }
        return customer;
    }

    public Customer getCustomer(long customerId) {
        return customerMap.get(customerId);
    }

    long nextCustomerId() {
        return ++lastCustomerId;
    }

}
