package test.org.mule.transport;

import org.mule.api.MuleMessage;
import org.mule.module.client.MuleClient;

import test.org.mule.tck.FunctionalTestCase;

public class VMTransportTest extends FunctionalTestCase {

    protected String getConfigResources() {
        return "test/org/mule/transport/VMTransportTest-config.xml";
    }

    public void testPassThrough_InOut() throws Exception {
        MuleClient client = new MuleClient();
        Object payload = new Object();
        MuleMessage result = client.send(
                "vm://PassThrough-InOut", payload, null);
        assertSame(payload, result.getPayload());
    }

    public void testTestComponent_InOut_String() throws Exception {
        MuleClient client = new MuleClient();
        MuleMessage result = client.send(
                "vm://Test-InOut", "abc", null);
        assertEquals("abc (Received)", result.getPayload());
    }

    public void testTestComponent_InOut_Integer() throws Exception {
        MuleClient client = new MuleClient();
        MuleMessage result = client.send(
                "vm://Test-InOut", 123, null);
        assertEquals("123 (Received)", result.getPayload());
    }

}
