package com.example.echo.client;

import java.util.HashMap;
import java.util.Map;

import javax.xml.namespace.QName;

import org.mule.api.MuleMessage;
import org.mule.module.client.MuleClient;
import org.mule.transport.soap.NamedParameter;
import org.mule.transport.soap.SoapMethod;

import junit.framework.TestCase;

public class EchoMuleClientTest extends TestCase {

    static final String ENDPOINT_BASE =
            "http://localhost:8080/mule-example/services/";

    public void testEchoAxisRE() throws Exception {
        String endpoint = "axis:" + ENDPOINT_BASE + "echoAxisRE?method=echo";
        MuleClient client = new MuleClient();
        MuleMessage message = client.send(endpoint, new Object[] {"Hello!"}, null);
        assertEquals("Hello!", message.getPayload());
    }

    public void testEchoAxisRE_withConfig() throws Exception {
        MuleClient client = new MuleClient("echo-axis-client-config.xml");
        MuleMessage message = client.send("echoAxisRE", new Object[] {"Hello!"}, null);
        assertEquals("Hello!", message.getPayload());
    }

    public void testEchoAxisWL() throws Exception {
        String endpoint = "axis:" + ENDPOINT_BASE + "echoAxisWL";
        MuleClient client = new MuleClient();
        Map<String, Object> props = new HashMap<String, Object>();
        props.put("style", "wrapped");
        props.put("use", "literal");
        SoapMethod method = new SoapMethod(
                new QName("http://simple.component.api.mule.org", "echo"));
        method.addNamedParameter(
                new QName("http://simple.component.api.mule.org", "text"),
                NamedParameter.XSD_STRING, "in");
        method.setReturnType(NamedParameter.XSD_STRING);
        props.put("method", method);
        MuleMessage message = client.send(endpoint, new Object[] {"Hello!"}, props);
        assertEquals("Hello!", message.getPayload());
    }

    public void testEchoAxisWL_withConfig() throws Exception {
        MuleClient client = new MuleClient("echo-axis-client-config.xml");
        MuleMessage message = client.send("echoAxisWL", new Object[] {"Hello!"}, null);
        assertEquals("Hello!", message.getPayload());
    }

}
